package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTaskFlowGraph invokes the dms_enterprise.GetTaskFlowGraph API synchronously
func (client *Client) GetTaskFlowGraph(request *GetTaskFlowGraphRequest) (response *GetTaskFlowGraphResponse, err error) {
	response = CreateGetTaskFlowGraphResponse()
	err = client.DoAction(request, response)
	return
}

// GetTaskFlowGraphWithChan invokes the dms_enterprise.GetTaskFlowGraph API asynchronously
func (client *Client) GetTaskFlowGraphWithChan(request *GetTaskFlowGraphRequest) (<-chan *GetTaskFlowGraphResponse, <-chan error) {
	responseChan := make(chan *GetTaskFlowGraphResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTaskFlowGraph(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTaskFlowGraphWithCallback invokes the dms_enterprise.GetTaskFlowGraph API asynchronously
func (client *Client) GetTaskFlowGraphWithCallback(request *GetTaskFlowGraphRequest, callback func(response *GetTaskFlowGraphResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTaskFlowGraphResponse
		var err error
		defer close(result)
		response, err = client.GetTaskFlowGraph(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTaskFlowGraphRequest is the request struct for api GetTaskFlowGraph
type GetTaskFlowGraphRequest struct {
	*requests.RpcRequest
	DagId requests.Integer `position:"Query" name:"DagId"`
	Tid   requests.Integer `position:"Query" name:"Tid"`
}

// GetTaskFlowGraphResponse is the response struct for api GetTaskFlowGraph
type GetTaskFlowGraphResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	ErrorCode     string        `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage  string        `json:"ErrorMessage" xml:"ErrorMessage"`
	Success       bool          `json:"Success" xml:"Success"`
	TaskFlowGraph TaskFlowGraph `json:"TaskFlowGraph" xml:"TaskFlowGraph"`
}

// CreateGetTaskFlowGraphRequest creates a request to invoke GetTaskFlowGraph API
func CreateGetTaskFlowGraphRequest() (request *GetTaskFlowGraphRequest) {
	request = &GetTaskFlowGraphRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GetTaskFlowGraph", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetTaskFlowGraphResponse creates a response to parse from GetTaskFlowGraph response
func CreateGetTaskFlowGraphResponse() (response *GetTaskFlowGraphResponse) {
	response = &GetTaskFlowGraphResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
