package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSensitiveColumnInfo invokes the dms_enterprise.ListSensitiveColumnInfo API synchronously
func (client *Client) ListSensitiveColumnInfo(request *ListSensitiveColumnInfoRequest) (response *ListSensitiveColumnInfoResponse, err error) {
	response = CreateListSensitiveColumnInfoResponse()
	err = client.DoAction(request, response)
	return
}

// ListSensitiveColumnInfoWithChan invokes the dms_enterprise.ListSensitiveColumnInfo API asynchronously
func (client *Client) ListSensitiveColumnInfoWithChan(request *ListSensitiveColumnInfoRequest) (<-chan *ListSensitiveColumnInfoResponse, <-chan error) {
	responseChan := make(chan *ListSensitiveColumnInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSensitiveColumnInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSensitiveColumnInfoWithCallback invokes the dms_enterprise.ListSensitiveColumnInfo API asynchronously
func (client *Client) ListSensitiveColumnInfoWithCallback(request *ListSensitiveColumnInfoRequest, callback func(response *ListSensitiveColumnInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSensitiveColumnInfoResponse
		var err error
		defer close(result)
		response, err = client.ListSensitiveColumnInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSensitiveColumnInfoRequest is the request struct for api ListSensitiveColumnInfo
type ListSensitiveColumnInfoRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	Tid        requests.Integer `position:"Query" name:"Tid"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	TableName  string           `position:"Query" name:"TableName"`
	SchemaName string           `position:"Query" name:"SchemaName"`
	ColumnName string           `position:"Query" name:"ColumnName"`
	InstanceId requests.Integer `position:"Query" name:"InstanceId"`
}

// ListSensitiveColumnInfoResponse is the response struct for api ListSensitiveColumnInfo
type ListSensitiveColumnInfoResponse struct {
	*responses.BaseResponse
	RequestId           string                                       `json:"RequestId" xml:"RequestId"`
	ErrorCode           string                                       `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage        string                                       `json:"ErrorMessage" xml:"ErrorMessage"`
	Success             bool                                         `json:"Success" xml:"Success"`
	TotalCount          int64                                        `json:"TotalCount" xml:"TotalCount"`
	SensitiveColumnList SensitiveColumnListInListSensitiveColumnInfo `json:"SensitiveColumnList" xml:"SensitiveColumnList"`
}

// CreateListSensitiveColumnInfoRequest creates a request to invoke ListSensitiveColumnInfo API
func CreateListSensitiveColumnInfoRequest() (request *ListSensitiveColumnInfoRequest) {
	request = &ListSensitiveColumnInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "ListSensitiveColumnInfo", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListSensitiveColumnInfoResponse creates a response to parse from ListSensitiveColumnInfo response
func CreateListSensitiveColumnInfoResponse() (response *ListSensitiveColumnInfoResponse) {
	response = &ListSensitiveColumnInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
