package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTaskFlowNameAndDesc invokes the dms_enterprise.UpdateTaskFlowNameAndDesc API synchronously
func (client *Client) UpdateTaskFlowNameAndDesc(request *UpdateTaskFlowNameAndDescRequest) (response *UpdateTaskFlowNameAndDescResponse, err error) {
	response = CreateUpdateTaskFlowNameAndDescResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTaskFlowNameAndDescWithChan invokes the dms_enterprise.UpdateTaskFlowNameAndDesc API asynchronously
func (client *Client) UpdateTaskFlowNameAndDescWithChan(request *UpdateTaskFlowNameAndDescRequest) (<-chan *UpdateTaskFlowNameAndDescResponse, <-chan error) {
	responseChan := make(chan *UpdateTaskFlowNameAndDescResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTaskFlowNameAndDesc(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTaskFlowNameAndDescWithCallback invokes the dms_enterprise.UpdateTaskFlowNameAndDesc API asynchronously
func (client *Client) UpdateTaskFlowNameAndDescWithCallback(request *UpdateTaskFlowNameAndDescRequest, callback func(response *UpdateTaskFlowNameAndDescResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTaskFlowNameAndDescResponse
		var err error
		defer close(result)
		response, err = client.UpdateTaskFlowNameAndDesc(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTaskFlowNameAndDescRequest is the request struct for api UpdateTaskFlowNameAndDesc
type UpdateTaskFlowNameAndDescRequest struct {
	*requests.RpcRequest
	DagName     string           `position:"Query" name:"DagName"`
	Description string           `position:"Query" name:"Description"`
	DagId       requests.Integer `position:"Query" name:"DagId"`
	Tid         requests.Integer `position:"Query" name:"Tid"`
}

// UpdateTaskFlowNameAndDescResponse is the response struct for api UpdateTaskFlowNameAndDesc
type UpdateTaskFlowNameAndDescResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateUpdateTaskFlowNameAndDescRequest creates a request to invoke UpdateTaskFlowNameAndDesc API
func CreateUpdateTaskFlowNameAndDescRequest() (request *UpdateTaskFlowNameAndDescRequest) {
	request = &UpdateTaskFlowNameAndDescRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "UpdateTaskFlowNameAndDesc", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateTaskFlowNameAndDescResponse creates a response to parse from UpdateTaskFlowNameAndDesc response
func CreateUpdateTaskFlowNameAndDescResponse() (response *UpdateTaskFlowNameAndDescResponse) {
	response = &UpdateTaskFlowNameAndDescResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
