package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDrdsDbRdsRelationInfo invokes the drds.GetDrdsDbRdsRelationInfo API synchronously
func (client *Client) GetDrdsDbRdsRelationInfo(request *GetDrdsDbRdsRelationInfoRequest) (response *GetDrdsDbRdsRelationInfoResponse, err error) {
	response = CreateGetDrdsDbRdsRelationInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetDrdsDbRdsRelationInfoWithChan invokes the drds.GetDrdsDbRdsRelationInfo API asynchronously
func (client *Client) GetDrdsDbRdsRelationInfoWithChan(request *GetDrdsDbRdsRelationInfoRequest) (<-chan *GetDrdsDbRdsRelationInfoResponse, <-chan error) {
	responseChan := make(chan *GetDrdsDbRdsRelationInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDrdsDbRdsRelationInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDrdsDbRdsRelationInfoWithCallback invokes the drds.GetDrdsDbRdsRelationInfo API asynchronously
func (client *Client) GetDrdsDbRdsRelationInfoWithCallback(request *GetDrdsDbRdsRelationInfoRequest, callback func(response *GetDrdsDbRdsRelationInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDrdsDbRdsRelationInfoResponse
		var err error
		defer close(result)
		response, err = client.GetDrdsDbRdsRelationInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDrdsDbRdsRelationInfoRequest is the request struct for api GetDrdsDbRdsRelationInfo
type GetDrdsDbRdsRelationInfoRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
	DbName         string `position:"Query" name:"DbName"`
}

// GetDrdsDbRdsRelationInfoResponse is the response struct for api GetDrdsDbRdsRelationInfo
type GetDrdsDbRdsRelationInfoResponse struct {
	*responses.BaseResponse
	Success   bool       `json:"Success" xml:"Success"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateGetDrdsDbRdsRelationInfoRequest creates a request to invoke GetDrdsDbRdsRelationInfo API
func CreateGetDrdsDbRdsRelationInfoRequest() (request *GetDrdsDbRdsRelationInfoRequest) {
	request = &GetDrdsDbRdsRelationInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "GetDrdsDbRdsRelationInfo", "drds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetDrdsDbRdsRelationInfoResponse creates a response to parse from GetDrdsDbRdsRelationInfo response
func CreateGetDrdsDbRdsRelationInfoResponse() (response *GetDrdsDbRdsRelationInfoResponse) {
	response = &GetDrdsDbRdsRelationInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
