package dysmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryPageSmartShortUrlLog invokes the dysmsapi.QueryPageSmartShortUrlLog API synchronously
func (client *Client) QueryPageSmartShortUrlLog(request *QueryPageSmartShortUrlLogRequest) (response *QueryPageSmartShortUrlLogResponse, err error) {
	response = CreateQueryPageSmartShortUrlLogResponse()
	err = client.DoAction(request, response)
	return
}

// QueryPageSmartShortUrlLogWithChan invokes the dysmsapi.QueryPageSmartShortUrlLog API asynchronously
func (client *Client) QueryPageSmartShortUrlLogWithChan(request *QueryPageSmartShortUrlLogRequest) (<-chan *QueryPageSmartShortUrlLogResponse, <-chan error) {
	responseChan := make(chan *QueryPageSmartShortUrlLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryPageSmartShortUrlLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryPageSmartShortUrlLogWithCallback invokes the dysmsapi.QueryPageSmartShortUrlLog API asynchronously
func (client *Client) QueryPageSmartShortUrlLogWithCallback(request *QueryPageSmartShortUrlLogRequest, callback func(response *QueryPageSmartShortUrlLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryPageSmartShortUrlLogResponse
		var err error
		defer close(result)
		response, err = client.QueryPageSmartShortUrlLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryPageSmartShortUrlLogRequest is the request struct for api QueryPageSmartShortUrlLog
type QueryPageSmartShortUrlLogRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CreateDateEnd        requests.Integer `position:"Query" name:"CreateDateEnd"`
	CreateDateStart      requests.Integer `position:"Query" name:"CreateDateStart"`
	PhoneNumber          string           `position:"Query" name:"PhoneNumber"`
	ExtendFunction       string           `position:"Query" name:"ExtendFunction"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	RouteName            string           `position:"Query" name:"RouteName"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ShortUrl             string           `position:"Query" name:"ShortUrl"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PageNo               requests.Integer `position:"Query" name:"PageNo"`
}

// QueryPageSmartShortUrlLogResponse is the response struct for api QueryPageSmartShortUrlLog
type QueryPageSmartShortUrlLogResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Model     Model  `json:"Model" xml:"Model"`
}

// CreateQueryPageSmartShortUrlLogRequest creates a request to invoke QueryPageSmartShortUrlLog API
func CreateQueryPageSmartShortUrlLogRequest() (request *QueryPageSmartShortUrlLogRequest) {
	request = &QueryPageSmartShortUrlLogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dysmsapi", "2017-05-25", "QueryPageSmartShortUrlLog", "dysms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryPageSmartShortUrlLogResponse creates a response to parse from QueryPageSmartShortUrlLog response
func CreateQueryPageSmartShortUrlLogResponse() (response *QueryPageSmartShortUrlLogResponse) {
	response = &QueryPageSmartShortUrlLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
