package dysmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SendMessageWithTemplate invokes the dysmsapi.SendMessageWithTemplate API synchronously
func (client *Client) SendMessageWithTemplate(request *SendMessageWithTemplateRequest) (response *SendMessageWithTemplateResponse, err error) {
	response = CreateSendMessageWithTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// SendMessageWithTemplateWithChan invokes the dysmsapi.SendMessageWithTemplate API asynchronously
func (client *Client) SendMessageWithTemplateWithChan(request *SendMessageWithTemplateRequest) (<-chan *SendMessageWithTemplateResponse, <-chan error) {
	responseChan := make(chan *SendMessageWithTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SendMessageWithTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SendMessageWithTemplateWithCallback invokes the dysmsapi.SendMessageWithTemplate API asynchronously
func (client *Client) SendMessageWithTemplateWithCallback(request *SendMessageWithTemplateRequest, callback func(response *SendMessageWithTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SendMessageWithTemplateResponse
		var err error
		defer close(result)
		response, err = client.SendMessageWithTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SendMessageWithTemplateRequest is the request struct for api SendMessageWithTemplate
type SendMessageWithTemplateRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SmsUpExtendCode      string           `position:"Query" name:"SmsUpExtendCode"`
	From                 string           `position:"Query" name:"From"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ValidityPeriod       requests.Integer `position:"Query" name:"ValidityPeriod"`
	To                   string           `position:"Query" name:"To"`
	TemplateCode         string           `position:"Query" name:"TemplateCode"`
	ChannelId            string           `position:"Query" name:"ChannelId"`
	TemplateParam        string           `position:"Query" name:"TemplateParam"`
}

// SendMessageWithTemplateResponse is the response struct for api SendMessageWithTemplate
type SendMessageWithTemplateResponse struct {
	*responses.BaseResponse
	ResponseCode        string       `json:"ResponseCode" xml:"ResponseCode"`
	ResponseDescription string       `json:"ResponseDescription" xml:"ResponseDescription"`
	Segments            string       `json:"Segments" xml:"Segments"`
	To                  string       `json:"To" xml:"To"`
	MessageId           string       `json:"MessageId" xml:"MessageId"`
	RequestId           string       `json:"RequestId" xml:"RequestId"`
	NumberDetail        NumberDetail `json:"NumberDetail" xml:"NumberDetail"`
}

// CreateSendMessageWithTemplateRequest creates a request to invoke SendMessageWithTemplate API
func CreateSendMessageWithTemplateRequest() (request *SendMessageWithTemplateRequest) {
	request = &SendMessageWithTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dysmsapi", "2018-05-01", "SendMessageWithTemplate", "dysms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSendMessageWithTemplateResponse creates a response to parse from SendMessageWithTemplate response
func CreateSendMessageWithTemplateResponse() (response *SendMessageWithTemplateResponse) {
	response = &SendMessageWithTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
