package dytnsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEmptyNumber invokes the dytnsapi.DescribeEmptyNumber API synchronously
func (client *Client) DescribeEmptyNumber(request *DescribeEmptyNumberRequest) (response *DescribeEmptyNumberResponse, err error) {
	response = CreateDescribeEmptyNumberResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEmptyNumberWithChan invokes the dytnsapi.DescribeEmptyNumber API asynchronously
func (client *Client) DescribeEmptyNumberWithChan(request *DescribeEmptyNumberRequest) (<-chan *DescribeEmptyNumberResponse, <-chan error) {
	responseChan := make(chan *DescribeEmptyNumberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEmptyNumber(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEmptyNumberWithCallback invokes the dytnsapi.DescribeEmptyNumber API asynchronously
func (client *Client) DescribeEmptyNumberWithCallback(request *DescribeEmptyNumberRequest, callback func(response *DescribeEmptyNumberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEmptyNumberResponse
		var err error
		defer close(result)
		response, err = client.DescribeEmptyNumber(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEmptyNumberRequest is the request struct for api DescribeEmptyNumber
type DescribeEmptyNumberRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ExtendFunction       string           `position:"Query" name:"ExtendFunction"`
	RouteName            string           `position:"Query" name:"RouteName"`
	Mask                 string           `position:"Query" name:"Mask"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	AuthCode             string           `position:"Query" name:"AuthCode"`
	InputNumber          string           `position:"Query" name:"InputNumber"`
}

// DescribeEmptyNumberResponse is the response struct for api DescribeEmptyNumber
type DescribeEmptyNumberResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeEmptyNumberRequest creates a request to invoke DescribeEmptyNumber API
func CreateDescribeEmptyNumberRequest() (request *DescribeEmptyNumberRequest) {
	request = &DescribeEmptyNumberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dytnsapi", "2020-02-17", "DescribeEmptyNumber", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeEmptyNumberResponse creates a response to parse from DescribeEmptyNumber response
func CreateDescribeEmptyNumberResponse() (response *DescribeEmptyNumberResponse) {
	response = &DescribeEmptyNumberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
