package dytnsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InvalidPhoneNumberFilter invokes the dytnsapi.InvalidPhoneNumberFilter API synchronously
func (client *Client) InvalidPhoneNumberFilter(request *InvalidPhoneNumberFilterRequest) (response *InvalidPhoneNumberFilterResponse, err error) {
	response = CreateInvalidPhoneNumberFilterResponse()
	err = client.DoAction(request, response)
	return
}

// InvalidPhoneNumberFilterWithChan invokes the dytnsapi.InvalidPhoneNumberFilter API asynchronously
func (client *Client) InvalidPhoneNumberFilterWithChan(request *InvalidPhoneNumberFilterRequest) (<-chan *InvalidPhoneNumberFilterResponse, <-chan error) {
	responseChan := make(chan *InvalidPhoneNumberFilterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InvalidPhoneNumberFilter(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InvalidPhoneNumberFilterWithCallback invokes the dytnsapi.InvalidPhoneNumberFilter API asynchronously
func (client *Client) InvalidPhoneNumberFilterWithCallback(request *InvalidPhoneNumberFilterRequest, callback func(response *InvalidPhoneNumberFilterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InvalidPhoneNumberFilterResponse
		var err error
		defer close(result)
		response, err = client.InvalidPhoneNumberFilter(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InvalidPhoneNumberFilterRequest is the request struct for api InvalidPhoneNumberFilter
type InvalidPhoneNumberFilterRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Mask                 string           `position:"Query" name:"Mask"`
	OfferType            string           `position:"Query" name:"OfferType"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	AuthCode             string           `position:"Query" name:"AuthCode"`
	InputNumber          string           `position:"Query" name:"InputNumber"`
}

// InvalidPhoneNumberFilterResponse is the response struct for api InvalidPhoneNumberFilter
type InvalidPhoneNumberFilterResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Code      string     `json:"Code" xml:"Code"`
	Message   string     `json:"Message" xml:"Message"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateInvalidPhoneNumberFilterRequest creates a request to invoke InvalidPhoneNumberFilter API
func CreateInvalidPhoneNumberFilterRequest() (request *InvalidPhoneNumberFilterRequest) {
	request = &InvalidPhoneNumberFilterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dytnsapi", "2020-02-17", "InvalidPhoneNumberFilter", "", "")
	request.Method = requests.POST
	return
}

// CreateInvalidPhoneNumberFilterResponse creates a response to parse from InvalidPhoneNumberFilter response
func CreateInvalidPhoneNumberFilterResponse() (response *InvalidPhoneNumberFilterResponse) {
	response = &InvalidPhoneNumberFilterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
