package eais

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartEaiJupyter invokes the eais.StartEaiJupyter API synchronously
func (client *Client) StartEaiJupyter(request *StartEaiJupyterRequest) (response *StartEaiJupyterResponse, err error) {
	response = CreateStartEaiJupyterResponse()
	err = client.DoAction(request, response)
	return
}

// StartEaiJupyterWithChan invokes the eais.StartEaiJupyter API asynchronously
func (client *Client) StartEaiJupyterWithChan(request *StartEaiJupyterRequest) (<-chan *StartEaiJupyterResponse, <-chan error) {
	responseChan := make(chan *StartEaiJupyterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartEaiJupyter(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartEaiJupyterWithCallback invokes the eais.StartEaiJupyter API asynchronously
func (client *Client) StartEaiJupyterWithCallback(request *StartEaiJupyterRequest, callback func(response *StartEaiJupyterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartEaiJupyterResponse
		var err error
		defer close(result)
		response, err = client.StartEaiJupyter(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartEaiJupyterRequest is the request struct for api StartEaiJupyter
type StartEaiJupyterRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// StartEaiJupyterResponse is the response struct for api StartEaiJupyter
type StartEaiJupyterResponse struct {
	*responses.BaseResponse
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	AccessDeniedDetail AccessDeniedDetail `json:"AccessDeniedDetail" xml:"AccessDeniedDetail"`
}

// CreateStartEaiJupyterRequest creates a request to invoke StartEaiJupyter API
func CreateStartEaiJupyterRequest() (request *StartEaiJupyterRequest) {
	request = &StartEaiJupyterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eais", "2019-06-24", "StartEaiJupyter", "eais", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStartEaiJupyterResponse creates a response to parse from StartEaiJupyter response
func CreateStartEaiJupyterResponse() (response *StartEaiJupyterResponse) {
	response = &StartEaiJupyterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
