package ebs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDedicatedBlockStorageClusterAttribute invokes the ebs.ModifyDedicatedBlockStorageClusterAttribute API synchronously
func (client *Client) ModifyDedicatedBlockStorageClusterAttribute(request *ModifyDedicatedBlockStorageClusterAttributeRequest) (response *ModifyDedicatedBlockStorageClusterAttributeResponse, err error) {
	response = CreateModifyDedicatedBlockStorageClusterAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDedicatedBlockStorageClusterAttributeWithChan invokes the ebs.ModifyDedicatedBlockStorageClusterAttribute API asynchronously
func (client *Client) ModifyDedicatedBlockStorageClusterAttributeWithChan(request *ModifyDedicatedBlockStorageClusterAttributeRequest) (<-chan *ModifyDedicatedBlockStorageClusterAttributeResponse, <-chan error) {
	responseChan := make(chan *ModifyDedicatedBlockStorageClusterAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDedicatedBlockStorageClusterAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDedicatedBlockStorageClusterAttributeWithCallback invokes the ebs.ModifyDedicatedBlockStorageClusterAttribute API asynchronously
func (client *Client) ModifyDedicatedBlockStorageClusterAttributeWithCallback(request *ModifyDedicatedBlockStorageClusterAttributeRequest, callback func(response *ModifyDedicatedBlockStorageClusterAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDedicatedBlockStorageClusterAttributeResponse
		var err error
		defer close(result)
		response, err = client.ModifyDedicatedBlockStorageClusterAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDedicatedBlockStorageClusterAttributeRequest is the request struct for api ModifyDedicatedBlockStorageClusterAttribute
type ModifyDedicatedBlockStorageClusterAttributeRequest struct {
	*requests.RpcRequest
	DbscName    string `position:"Query" name:"DbscName"`
	ClientToken string `position:"Query" name:"ClientToken"`
	Description string `position:"Query" name:"Description"`
	DbscId      string `position:"Query" name:"DbscId"`
}

// ModifyDedicatedBlockStorageClusterAttributeResponse is the response struct for api ModifyDedicatedBlockStorageClusterAttribute
type ModifyDedicatedBlockStorageClusterAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDedicatedBlockStorageClusterAttributeRequest creates a request to invoke ModifyDedicatedBlockStorageClusterAttribute API
func CreateModifyDedicatedBlockStorageClusterAttributeRequest() (request *ModifyDedicatedBlockStorageClusterAttributeRequest) {
	request = &ModifyDedicatedBlockStorageClusterAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ebs", "2021-07-30", "ModifyDedicatedBlockStorageClusterAttribute", "ebs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDedicatedBlockStorageClusterAttributeResponse creates a response to parse from ModifyDedicatedBlockStorageClusterAttribute response
func CreateModifyDedicatedBlockStorageClusterAttributeResponse() (response *ModifyDedicatedBlockStorageClusterAttributeResponse) {
	response = &ModifyDedicatedBlockStorageClusterAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
