package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDesktopsInGroup invokes the ecd.DescribeDesktopsInGroup API synchronously
func (client *Client) DescribeDesktopsInGroup(request *DescribeDesktopsInGroupRequest) (response *DescribeDesktopsInGroupResponse, err error) {
	response = CreateDescribeDesktopsInGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDesktopsInGroupWithChan invokes the ecd.DescribeDesktopsInGroup API asynchronously
func (client *Client) DescribeDesktopsInGroupWithChan(request *DescribeDesktopsInGroupRequest) (<-chan *DescribeDesktopsInGroupResponse, <-chan error) {
	responseChan := make(chan *DescribeDesktopsInGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDesktopsInGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDesktopsInGroupWithCallback invokes the ecd.DescribeDesktopsInGroup API asynchronously
func (client *Client) DescribeDesktopsInGroupWithCallback(request *DescribeDesktopsInGroupRequest, callback func(response *DescribeDesktopsInGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDesktopsInGroupResponse
		var err error
		defer close(result)
		response, err = client.DescribeDesktopsInGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDesktopsInGroupRequest is the request struct for api DescribeDesktopsInGroup
type DescribeDesktopsInGroupRequest struct {
	*requests.RpcRequest
	IgnoreDeleted  requests.Boolean `position:"Query" name:"IgnoreDeleted"`
	DesktopGroupId string           `position:"Query" name:"DesktopGroupId"`
	NextToken      string           `position:"Query" name:"NextToken"`
	MaxResults     requests.Integer `position:"Query" name:"MaxResults"`
	PayType        string           `position:"Query" name:"PayType"`
}

// DescribeDesktopsInGroupResponse is the response struct for api DescribeDesktopsInGroup
type DescribeDesktopsInGroupResponse struct {
	*responses.BaseResponse
	PostPaidDesktopsCount       int               `json:"PostPaidDesktopsCount" xml:"PostPaidDesktopsCount"`
	NextToken                   string            `json:"NextToken" xml:"NextToken"`
	PaidDesktopsCount           int               `json:"PaidDesktopsCount" xml:"PaidDesktopsCount"`
	RequestId                   string            `json:"RequestId" xml:"RequestId"`
	PostPaidDesktopsTotalAmount int               `json:"PostPaidDesktopsTotalAmount" xml:"PostPaidDesktopsTotalAmount"`
	OnlinePrePaidDesktopsCount  int               `json:"OnlinePrePaidDesktopsCount" xml:"OnlinePrePaidDesktopsCount"`
	RunningPrePaidDesktopsCount int               `json:"RunningPrePaidDesktopsCount" xml:"RunningPrePaidDesktopsCount"`
	StopedPrePaidDesktopsCount  int               `json:"StopedPrePaidDesktopsCount" xml:"StopedPrePaidDesktopsCount"`
	StoppedPrePaidDesktopsCount int               `json:"StoppedPrePaidDesktopsCount" xml:"StoppedPrePaidDesktopsCount"`
	PaidDesktops                []PaidDesktop     `json:"PaidDesktops" xml:"PaidDesktops"`
	PostPaidDesktops            []PostPaidDesktop `json:"PostPaidDesktops" xml:"PostPaidDesktops"`
}

// CreateDescribeDesktopsInGroupRequest creates a request to invoke DescribeDesktopsInGroup API
func CreateDescribeDesktopsInGroupRequest() (request *DescribeDesktopsInGroupRequest) {
	request = &DescribeDesktopsInGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeDesktopsInGroup", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDesktopsInGroupResponse creates a response to parse from DescribeDesktopsInGroup response
func CreateDescribeDesktopsInGroupResponse() (response *DescribeDesktopsInGroupResponse) {
	response = &DescribeDesktopsInGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
