package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DownloadCdsFile invokes the ecd.DownloadCdsFile API synchronously
func (client *Client) DownloadCdsFile(request *DownloadCdsFileRequest) (response *DownloadCdsFileResponse, err error) {
	response = CreateDownloadCdsFileResponse()
	err = client.DoAction(request, response)
	return
}

// DownloadCdsFileWithChan invokes the ecd.DownloadCdsFile API asynchronously
func (client *Client) DownloadCdsFileWithChan(request *DownloadCdsFileRequest) (<-chan *DownloadCdsFileResponse, <-chan error) {
	responseChan := make(chan *DownloadCdsFileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DownloadCdsFile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DownloadCdsFileWithCallback invokes the ecd.DownloadCdsFile API asynchronously
func (client *Client) DownloadCdsFileWithCallback(request *DownloadCdsFileRequest, callback func(response *DownloadCdsFileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DownloadCdsFileResponse
		var err error
		defer close(result)
		response, err = client.DownloadCdsFile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DownloadCdsFileRequest is the request struct for api DownloadCdsFile
type DownloadCdsFileRequest struct {
	*requests.RpcRequest
	GroupId   string `position:"Query" name:"GroupId"`
	CdsId     string `position:"Query" name:"CdsId"`
	EndUserId string `position:"Query" name:"EndUserId"`
	FileId    string `position:"Query" name:"FileId"`
}

// DownloadCdsFileResponse is the response struct for api DownloadCdsFile
type DownloadCdsFileResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	Message           string            `json:"Message" xml:"Message"`
	Success           bool              `json:"Success" xml:"Success"`
	DownloadFileModel DownloadFileModel `json:"DownloadFileModel" xml:"DownloadFileModel"`
}

// CreateDownloadCdsFileRequest creates a request to invoke DownloadCdsFile API
func CreateDownloadCdsFileRequest() (request *DownloadCdsFileRequest) {
	request = &DownloadCdsFileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DownloadCdsFile", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDownloadCdsFileResponse creates a response to parse from DownloadCdsFile response
func CreateDownloadCdsFileResponse() (response *DownloadCdsFileResponse) {
	response = &DownloadCdsFileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
