package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExportDesktopGroupInfo invokes the ecd.ExportDesktopGroupInfo API synchronously
func (client *Client) ExportDesktopGroupInfo(request *ExportDesktopGroupInfoRequest) (response *ExportDesktopGroupInfoResponse, err error) {
	response = CreateExportDesktopGroupInfoResponse()
	err = client.DoAction(request, response)
	return
}

// ExportDesktopGroupInfoWithChan invokes the ecd.ExportDesktopGroupInfo API asynchronously
func (client *Client) ExportDesktopGroupInfoWithChan(request *ExportDesktopGroupInfoRequest) (<-chan *ExportDesktopGroupInfoResponse, <-chan error) {
	responseChan := make(chan *ExportDesktopGroupInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExportDesktopGroupInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExportDesktopGroupInfoWithCallback invokes the ecd.ExportDesktopGroupInfo API asynchronously
func (client *Client) ExportDesktopGroupInfoWithCallback(request *ExportDesktopGroupInfoRequest, callback func(response *ExportDesktopGroupInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExportDesktopGroupInfoResponse
		var err error
		defer close(result)
		response, err = client.ExportDesktopGroupInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExportDesktopGroupInfoRequest is the request struct for api ExportDesktopGroupInfo
type ExportDesktopGroupInfoRequest struct {
	*requests.RpcRequest
	OfficeSiteId     string                       `position:"Query" name:"OfficeSiteId"`
	DesktopGroupName string                       `position:"Query" name:"DesktopGroupName"`
	DesktopGroupId   *[]string                    `position:"Query" name:"DesktopGroupId"  type:"Repeated"`
	NextToken        string                       `position:"Query" name:"NextToken"`
	DirectoryId      string                       `position:"Query" name:"DirectoryId"`
	EndUserId        *[]string                    `position:"Query" name:"EndUserId"  type:"Repeated"`
	Tag              *[]ExportDesktopGroupInfoTag `position:"Query" name:"Tag"  type:"Repeated"`
	ExpiredTime      string                       `position:"Query" name:"ExpiredTime"`
	MaxResults       requests.Integer             `position:"Query" name:"MaxResults"`
	LangType         string                       `position:"Query" name:"LangType"`
	ChargeType       string                       `position:"Query" name:"ChargeType"`
	PolicyGroupId    string                       `position:"Query" name:"PolicyGroupId"`
}

// ExportDesktopGroupInfoTag is a repeated param struct in ExportDesktopGroupInfoRequest
type ExportDesktopGroupInfoTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// ExportDesktopGroupInfoResponse is the response struct for api ExportDesktopGroupInfo
type ExportDesktopGroupInfoResponse struct {
	*responses.BaseResponse
	Url       string `json:"Url" xml:"Url"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateExportDesktopGroupInfoRequest creates a request to invoke ExportDesktopGroupInfo API
func CreateExportDesktopGroupInfoRequest() (request *ExportDesktopGroupInfoRequest) {
	request = &ExportDesktopGroupInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ExportDesktopGroupInfo", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateExportDesktopGroupInfoResponse creates a response to parse from ExportDesktopGroupInfo response
func CreateExportDesktopGroupInfoResponse() (response *ExportDesktopGroupInfoResponse) {
	response = &ExportDesktopGroupInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
