package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RebuildDesktops invokes the ecd.RebuildDesktops API synchronously
func (client *Client) RebuildDesktops(request *RebuildDesktopsRequest) (response *RebuildDesktopsResponse, err error) {
	response = CreateRebuildDesktopsResponse()
	err = client.DoAction(request, response)
	return
}

// RebuildDesktopsWithChan invokes the ecd.RebuildDesktops API asynchronously
func (client *Client) RebuildDesktopsWithChan(request *RebuildDesktopsRequest) (<-chan *RebuildDesktopsResponse, <-chan error) {
	responseChan := make(chan *RebuildDesktopsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RebuildDesktops(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RebuildDesktopsWithCallback invokes the ecd.RebuildDesktops API asynchronously
func (client *Client) RebuildDesktopsWithCallback(request *RebuildDesktopsRequest, callback func(response *RebuildDesktopsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RebuildDesktopsResponse
		var err error
		defer close(result)
		response, err = client.RebuildDesktops(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RebuildDesktopsRequest is the request struct for api RebuildDesktops
type RebuildDesktopsRequest struct {
	*requests.RpcRequest
	ImageId     string    `position:"Query" name:"ImageId"`
	Language    string    `position:"Query" name:"Language"`
	OperateType string    `position:"Query" name:"OperateType"`
	DesktopId   *[]string `position:"Query" name:"DesktopId"  type:"Repeated"`
}

// RebuildDesktopsResponse is the response struct for api RebuildDesktops
type RebuildDesktopsResponse struct {
	*responses.BaseResponse
	RequestId      string          `json:"RequestId" xml:"RequestId"`
	RebuildResults []RebuildResult `json:"RebuildResults" xml:"RebuildResults"`
}

// CreateRebuildDesktopsRequest creates a request to invoke RebuildDesktops API
func CreateRebuildDesktopsRequest() (request *RebuildDesktopsRequest) {
	request = &RebuildDesktopsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "RebuildDesktops", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRebuildDesktopsResponse creates a response to parse from RebuildDesktops response
func CreateRebuildDesktopsResponse() (response *RebuildDesktopsResponse) {
	response = &RebuildDesktopsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
