package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeActivations invokes the ecs.DescribeActivations API synchronously
func (client *Client) DescribeActivations(request *DescribeActivationsRequest) (response *DescribeActivationsResponse, err error) {
	response = CreateDescribeActivationsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeActivationsWithChan invokes the ecs.DescribeActivations API asynchronously
func (client *Client) DescribeActivationsWithChan(request *DescribeActivationsRequest) (<-chan *DescribeActivationsResponse, <-chan error) {
	responseChan := make(chan *DescribeActivationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeActivations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeActivationsWithCallback invokes the ecs.DescribeActivations API asynchronously
func (client *Client) DescribeActivationsWithCallback(request *DescribeActivationsRequest, callback func(response *DescribeActivationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeActivationsResponse
		var err error
		defer close(result)
		response, err = client.DescribeActivations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeActivationsRequest is the request struct for api DescribeActivations
type DescribeActivationsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer          `position:"Query" name:"ResourceOwnerId"`
	PageNumber           requests.Integer          `position:"Query" name:"PageNumber"`
	ResourceGroupId      string                    `position:"Query" name:"ResourceGroupId"`
	NextToken            string                    `position:"Query" name:"NextToken"`
	PageSize             requests.Integer          `position:"Query" name:"PageSize"`
	Tag                  *[]DescribeActivationsTag `position:"Query" name:"Tag"  type:"Repeated"`
	ResourceOwnerAccount string                    `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string                    `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer          `position:"Query" name:"OwnerId"`
	InstanceName         string                    `position:"Query" name:"InstanceName"`
	MaxResults           requests.Integer          `position:"Query" name:"MaxResults"`
	ActivationId         string                    `position:"Query" name:"ActivationId"`
}

// DescribeActivationsTag is a repeated param struct in DescribeActivationsRequest
type DescribeActivationsTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// DescribeActivationsResponse is the response struct for api DescribeActivations
type DescribeActivationsResponse struct {
	*responses.BaseResponse
	PageSize       int64        `json:"PageSize" xml:"PageSize"`
	RequestId      string       `json:"RequestId" xml:"RequestId"`
	PageNumber     int64        `json:"PageNumber" xml:"PageNumber"`
	TotalCount     int64        `json:"TotalCount" xml:"TotalCount"`
	NextToken      string       `json:"NextToken" xml:"NextToken"`
	ActivationList []Activation `json:"ActivationList" xml:"ActivationList"`
}

// CreateDescribeActivationsRequest creates a request to invoke DescribeActivations API
func CreateDescribeActivationsRequest() (request *DescribeActivationsRequest) {
	request = &DescribeActivationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DescribeActivations", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeActivationsResponse creates a response to parse from DescribeActivations response
func CreateDescribeActivationsResponse() (response *DescribeActivationsResponse) {
	response = &DescribeActivationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
