package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDiagnosticMetrics invokes the ecs.DescribeDiagnosticMetrics API synchronously
func (client *Client) DescribeDiagnosticMetrics(request *DescribeDiagnosticMetricsRequest) (response *DescribeDiagnosticMetricsResponse, err error) {
	response = CreateDescribeDiagnosticMetricsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDiagnosticMetricsWithChan invokes the ecs.DescribeDiagnosticMetrics API asynchronously
func (client *Client) DescribeDiagnosticMetricsWithChan(request *DescribeDiagnosticMetricsRequest) (<-chan *DescribeDiagnosticMetricsResponse, <-chan error) {
	responseChan := make(chan *DescribeDiagnosticMetricsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDiagnosticMetrics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDiagnosticMetricsWithCallback invokes the ecs.DescribeDiagnosticMetrics API asynchronously
func (client *Client) DescribeDiagnosticMetricsWithCallback(request *DescribeDiagnosticMetricsRequest, callback func(response *DescribeDiagnosticMetricsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDiagnosticMetricsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDiagnosticMetrics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDiagnosticMetricsRequest is the request struct for api DescribeDiagnosticMetrics
type DescribeDiagnosticMetricsRequest struct {
	*requests.RpcRequest
	MetricIds    *[]string        `position:"Query" name:"MetricIds"  type:"Repeated"`
	ResourceType string           `position:"Query" name:"ResourceType"`
	NextToken    string           `position:"Query" name:"NextToken"`
	MaxResults   requests.Integer `position:"Query" name:"MaxResults"`
}

// DescribeDiagnosticMetricsResponse is the response struct for api DescribeDiagnosticMetrics
type DescribeDiagnosticMetricsResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	NextToken string   `json:"NextToken" xml:"NextToken"`
	Metrics   []Metric `json:"Metrics" xml:"Metrics"`
}

// CreateDescribeDiagnosticMetricsRequest creates a request to invoke DescribeDiagnosticMetrics API
func CreateDescribeDiagnosticMetricsRequest() (request *DescribeDiagnosticMetricsRequest) {
	request = &DescribeDiagnosticMetricsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DescribeDiagnosticMetrics", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDiagnosticMetricsResponse creates a response to parse from DescribeDiagnosticMetrics response
func CreateDescribeDiagnosticMetricsResponse() (response *DescribeDiagnosticMetricsResponse) {
	response = &DescribeDiagnosticMetricsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
