package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableDiskEncryptionByDefault invokes the ecs.DisableDiskEncryptionByDefault API synchronously
func (client *Client) DisableDiskEncryptionByDefault(request *DisableDiskEncryptionByDefaultRequest) (response *DisableDiskEncryptionByDefaultResponse, err error) {
	response = CreateDisableDiskEncryptionByDefaultResponse()
	err = client.DoAction(request, response)
	return
}

// DisableDiskEncryptionByDefaultWithChan invokes the ecs.DisableDiskEncryptionByDefault API asynchronously
func (client *Client) DisableDiskEncryptionByDefaultWithChan(request *DisableDiskEncryptionByDefaultRequest) (<-chan *DisableDiskEncryptionByDefaultResponse, <-chan error) {
	responseChan := make(chan *DisableDiskEncryptionByDefaultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableDiskEncryptionByDefault(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableDiskEncryptionByDefaultWithCallback invokes the ecs.DisableDiskEncryptionByDefault API asynchronously
func (client *Client) DisableDiskEncryptionByDefaultWithCallback(request *DisableDiskEncryptionByDefaultRequest, callback func(response *DisableDiskEncryptionByDefaultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableDiskEncryptionByDefaultResponse
		var err error
		defer close(result)
		response, err = client.DisableDiskEncryptionByDefault(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableDiskEncryptionByDefaultRequest is the request struct for api DisableDiskEncryptionByDefault
type DisableDiskEncryptionByDefaultRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
}

// DisableDiskEncryptionByDefaultResponse is the response struct for api DisableDiskEncryptionByDefault
type DisableDiskEncryptionByDefaultResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDisableDiskEncryptionByDefaultRequest creates a request to invoke DisableDiskEncryptionByDefault API
func CreateDisableDiskEncryptionByDefaultRequest() (request *DisableDiskEncryptionByDefaultRequest) {
	request = &DisableDiskEncryptionByDefaultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DisableDiskEncryptionByDefault", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDisableDiskEncryptionByDefaultResponse creates a response to parse from DisableDiskEncryptionByDefault response
func CreateDisableDiskEncryptionByDefaultResponse() (response *DisableDiskEncryptionByDefaultResponse) {
	response = &DisableDiskEncryptionByDefaultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
