package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDiskDeployment invokes the ecs.ModifyDiskDeployment API synchronously
func (client *Client) ModifyDiskDeployment(request *ModifyDiskDeploymentRequest) (response *ModifyDiskDeploymentResponse, err error) {
	response = CreateModifyDiskDeploymentResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDiskDeploymentWithChan invokes the ecs.ModifyDiskDeployment API asynchronously
func (client *Client) ModifyDiskDeploymentWithChan(request *ModifyDiskDeploymentRequest) (<-chan *ModifyDiskDeploymentResponse, <-chan error) {
	responseChan := make(chan *ModifyDiskDeploymentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDiskDeployment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDiskDeploymentWithCallback invokes the ecs.ModifyDiskDeployment API asynchronously
func (client *Client) ModifyDiskDeploymentWithCallback(request *ModifyDiskDeploymentRequest, callback func(response *ModifyDiskDeploymentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDiskDeploymentResponse
		var err error
		defer close(result)
		response, err = client.ModifyDiskDeployment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDiskDeploymentRequest is the request struct for api ModifyDiskDeployment
type ModifyDiskDeploymentRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DiskCategory         string           `position:"Query" name:"DiskCategory"`
	DiskId               string           `position:"Query" name:"DiskId"`
	DryRun               requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	PerformanceLevel     string           `position:"Query" name:"PerformanceLevel"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	StorageClusterId     string           `position:"Query" name:"StorageClusterId"`
}

// ModifyDiskDeploymentResponse is the response struct for api ModifyDiskDeployment
type ModifyDiskDeploymentResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreateModifyDiskDeploymentRequest creates a request to invoke ModifyDiskDeployment API
func CreateModifyDiskDeploymentRequest() (request *ModifyDiskDeploymentRequest) {
	request = &ModifyDiskDeploymentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "ModifyDiskDeployment", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDiskDeploymentResponse creates a response to parse from ModifyDiskDeployment response
func CreateModifyDiskDeploymentResponse() (response *ModifyDiskDeploymentResponse) {
	response = &ModifyDiskDeploymentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
