package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPackageStorageCredential invokes the edas.GetPackageStorageCredential API synchronously
func (client *Client) GetPackageStorageCredential(request *GetPackageStorageCredentialRequest) (response *GetPackageStorageCredentialResponse, err error) {
	response = CreateGetPackageStorageCredentialResponse()
	err = client.DoAction(request, response)
	return
}

// GetPackageStorageCredentialWithChan invokes the edas.GetPackageStorageCredential API asynchronously
func (client *Client) GetPackageStorageCredentialWithChan(request *GetPackageStorageCredentialRequest) (<-chan *GetPackageStorageCredentialResponse, <-chan error) {
	responseChan := make(chan *GetPackageStorageCredentialResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPackageStorageCredential(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPackageStorageCredentialWithCallback invokes the edas.GetPackageStorageCredential API asynchronously
func (client *Client) GetPackageStorageCredentialWithCallback(request *GetPackageStorageCredentialRequest, callback func(response *GetPackageStorageCredentialResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPackageStorageCredentialResponse
		var err error
		defer close(result)
		response, err = client.GetPackageStorageCredential(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPackageStorageCredentialRequest is the request struct for api GetPackageStorageCredential
type GetPackageStorageCredentialRequest struct {
	*requests.RoaRequest
}

// GetPackageStorageCredentialResponse is the response struct for api GetPackageStorageCredential
type GetPackageStorageCredentialResponse struct {
	*responses.BaseResponse
	Code       int        `json:"Code" xml:"Code"`
	Message    string     `json:"Message" xml:"Message"`
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Credential Credential `json:"Credential" xml:"Credential"`
}

// CreateGetPackageStorageCredentialRequest creates a request to invoke GetPackageStorageCredential API
func CreateGetPackageStorageCredentialRequest() (request *GetPackageStorageCredentialRequest) {
	request = &GetPackageStorageCredentialRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "GetPackageStorageCredential", "/pop/v5/package_storage_credential", "Edas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetPackageStorageCredentialResponse creates a response to parse from GetPackageStorageCredential response
func CreateGetPackageStorageCredentialResponse() (response *GetPackageStorageCredentialResponse) {
	response = &GetPackageStorageCredentialResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
