package eflo_controller

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCluster invokes the eflo_controller.CreateCluster API synchronously
func (client *Client) CreateCluster(request *CreateClusterRequest) (response *CreateClusterResponse, err error) {
	response = CreateCreateClusterResponse()
	err = client.DoAction(request, response)
	return
}

// CreateClusterWithChan invokes the eflo_controller.CreateCluster API asynchronously
func (client *Client) CreateClusterWithChan(request *CreateClusterRequest) (<-chan *CreateClusterResponse, <-chan error) {
	responseChan := make(chan *CreateClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateClusterWithCallback invokes the eflo_controller.CreateCluster API asynchronously
func (client *Client) CreateClusterWithCallback(request *CreateClusterRequest, callback func(response *CreateClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateClusterResponse
		var err error
		defer close(result)
		response, err = client.CreateCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateClusterRequest is the request struct for api CreateCluster
type CreateClusterRequest struct {
	*requests.RpcRequest
	Components            *[]CreateClusterComponents `position:"Body" name:"Components"  type:"Json"`
	ClusterName           string                     `position:"Body" name:"ClusterName"`
	Networks              CreateClusterNetworks      `position:"Body" name:"Networks"  type:"Struct"`
	ResourceGroupId       string                     `position:"Body" name:"ResourceGroupId"`
	ClusterDescription    string                     `position:"Body" name:"ClusterDescription"`
	NodeGroups            *[]CreateClusterNodeGroups `position:"Body" name:"NodeGroups"  type:"Json"`
	Tag                   *[]CreateClusterTag        `position:"Query" name:"Tag"  type:"Repeated"`
	IgnoreFailedNodeTasks requests.Boolean           `position:"Body" name:"IgnoreFailedNodeTasks"`
	ClusterType           string                     `position:"Body" name:"ClusterType"`
}

// CreateClusterComponents is a repeated param struct in CreateClusterRequest
type CreateClusterComponents struct {
	ComponentType   string                                 `name:"ComponentType"`
	ComponentConfig CreateClusterComponentsComponentConfig `name:"ComponentConfig" type:"Struct"`
}

// CreateClusterNodeGroups is a repeated param struct in CreateClusterRequest
type CreateClusterNodeGroups struct {
	NodeGroupName        string                              `name:"NodeGroupName"`
	Nodes                *[]CreateClusterNodeGroupsNodesItem `name:"Nodes" type:"Repeated"`
	ImageId              string                              `name:"ImageId"`
	NodeGroupDescription string                              `name:"NodeGroupDescription"`
	ZoneId               string                              `name:"ZoneId"`
	MachineType          string                              `name:"MachineType"`
}

// CreateClusterComponentsComponentConfig is a repeated param struct in CreateClusterRequest
type CreateClusterComponentsComponentConfig struct {
	BasicArgs string    `name:"BasicArgs"`
	NodeUnits *[]string `name:"NodeUnits" type:"Repeated"`
}

// CreateClusterNodeGroupsNodesItem is a repeated param struct in CreateClusterRequest
type CreateClusterNodeGroupsNodesItem struct {
	Hostname      string `name:"Hostname"`
	LoginPassword string `name:"LoginPassword"`
	NodeId        string `name:"NodeId"`
}

// CreateClusterNetworks is a repeated param struct in CreateClusterRequest
type CreateClusterNetworks struct {
	NewVpdInfo CreateClusterNetworksNewVpdInfo `name:"NewVpdInfo" type:"Struct"`
}

// CreateClusterTag is a repeated param struct in CreateClusterRequest
type CreateClusterTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// CreateClusterNetworksNewVpdInfo is a repeated param struct in CreateClusterRequest
type CreateClusterNetworksNewVpdInfo struct {
	MonitorVswitchId string                                           `name:"MonitorVswitchId"`
	VpdSubnets       *[]CreateClusterNetworksNewVpdInfoVpdSubnetsItem `name:"VpdSubnets" type:"Repeated"`
	CloudLinkId      string                                           `name:"CloudLinkId"`
	VpdCidr          string                                           `name:"VpdCidr"`
	CloudLinkCidr    string                                           `name:"CloudLinkCidr"`
	CenId            string                                           `name:"CenId"`
	MonitorVpcId     string                                           `name:"MonitorVpcId"`
}

// CreateClusterNetworksNewVpdInfoVpdSubnetsItem is a repeated param struct in CreateClusterRequest
type CreateClusterNetworksNewVpdInfoVpdSubnetsItem struct {
	SubnetType string `name:"SubnetType"`
	ZoneId     string `name:"ZoneId"`
	SubnetCidr string `name:"SubnetCidr"`
}

// CreateClusterResponse is the response struct for api CreateCluster
type CreateClusterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ClusterId string `json:"ClusterId" xml:"ClusterId"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreateCreateClusterRequest creates a request to invoke CreateCluster API
func CreateCreateClusterRequest() (request *CreateClusterRequest) {
	request = &CreateClusterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo-controller", "2022-12-15", "CreateCluster", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateClusterResponse creates a response to parse from CreateCluster response
func CreateCreateClusterResponse() (response *CreateClusterResponse) {
	response = &CreateClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
