package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteVpdGrantRule invokes the eflo.DeleteVpdGrantRule API synchronously
func (client *Client) DeleteVpdGrantRule(request *DeleteVpdGrantRuleRequest) (response *DeleteVpdGrantRuleResponse, err error) {
	response = CreateDeleteVpdGrantRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteVpdGrantRuleWithChan invokes the eflo.DeleteVpdGrantRule API asynchronously
func (client *Client) DeleteVpdGrantRuleWithChan(request *DeleteVpdGrantRuleRequest) (<-chan *DeleteVpdGrantRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteVpdGrantRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteVpdGrantRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteVpdGrantRuleWithCallback invokes the eflo.DeleteVpdGrantRule API asynchronously
func (client *Client) DeleteVpdGrantRuleWithCallback(request *DeleteVpdGrantRuleRequest, callback func(response *DeleteVpdGrantRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteVpdGrantRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteVpdGrantRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteVpdGrantRuleRequest is the request struct for api DeleteVpdGrantRule
type DeleteVpdGrantRuleRequest struct {
	*requests.RpcRequest
	ErId          string `position:"Body" name:"ErId"`
	GrantTenantId string `position:"Body" name:"GrantTenantId"`
	InstanceId    string `position:"Body" name:"InstanceId"`
	GrantRuleId   string `position:"Body" name:"GrantRuleId"`
}

// DeleteVpdGrantRuleResponse is the response struct for api DeleteVpdGrantRule
type DeleteVpdGrantRuleResponse struct {
	*responses.BaseResponse
}

// CreateDeleteVpdGrantRuleRequest creates a request to invoke DeleteVpdGrantRule API
func CreateDeleteVpdGrantRuleRequest() (request *DeleteVpdGrantRuleRequest) {
	request = &DeleteVpdGrantRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "DeleteVpdGrantRule", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteVpdGrantRuleResponse creates a response to parse from DeleteVpdGrantRule response
func CreateDeleteVpdGrantRuleResponse() (response *DeleteVpdGrantRuleResponse) {
	response = &DeleteVpdGrantRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
