package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetElasticNetworkInterface invokes the eflo.GetElasticNetworkInterface API synchronously
func (client *Client) GetElasticNetworkInterface(request *GetElasticNetworkInterfaceRequest) (response *GetElasticNetworkInterfaceResponse, err error) {
	response = CreateGetElasticNetworkInterfaceResponse()
	err = client.DoAction(request, response)
	return
}

// GetElasticNetworkInterfaceWithChan invokes the eflo.GetElasticNetworkInterface API asynchronously
func (client *Client) GetElasticNetworkInterfaceWithChan(request *GetElasticNetworkInterfaceRequest) (<-chan *GetElasticNetworkInterfaceResponse, <-chan error) {
	responseChan := make(chan *GetElasticNetworkInterfaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetElasticNetworkInterface(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetElasticNetworkInterfaceWithCallback invokes the eflo.GetElasticNetworkInterface API asynchronously
func (client *Client) GetElasticNetworkInterfaceWithCallback(request *GetElasticNetworkInterfaceRequest, callback func(response *GetElasticNetworkInterfaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetElasticNetworkInterfaceResponse
		var err error
		defer close(result)
		response, err = client.GetElasticNetworkInterface(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetElasticNetworkInterfaceRequest is the request struct for api GetElasticNetworkInterface
type GetElasticNetworkInterfaceRequest struct {
	*requests.RpcRequest
	ElasticNetworkInterfaceId string `position:"Body" name:"ElasticNetworkInterfaceId"`
}

// GetElasticNetworkInterfaceResponse is the response struct for api GetElasticNetworkInterface
type GetElasticNetworkInterfaceResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateGetElasticNetworkInterfaceRequest creates a request to invoke GetElasticNetworkInterface API
func CreateGetElasticNetworkInterfaceRequest() (request *GetElasticNetworkInterfaceRequest) {
	request = &GetElasticNetworkInterfaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "GetElasticNetworkInterface", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetElasticNetworkInterfaceResponse creates a response to parse from GetElasticNetworkInterface response
func CreateGetElasticNetworkInterfaceResponse() (response *GetElasticNetworkInterfaceResponse) {
	response = &GetElasticNetworkInterfaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
