package eipanycast

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAnycastEipAddressAssociations invokes the eipanycast.UpdateAnycastEipAddressAssociations API synchronously
func (client *Client) UpdateAnycastEipAddressAssociations(request *UpdateAnycastEipAddressAssociationsRequest) (response *UpdateAnycastEipAddressAssociationsResponse, err error) {
	response = CreateUpdateAnycastEipAddressAssociationsResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAnycastEipAddressAssociationsWithChan invokes the eipanycast.UpdateAnycastEipAddressAssociations API asynchronously
func (client *Client) UpdateAnycastEipAddressAssociationsWithChan(request *UpdateAnycastEipAddressAssociationsRequest) (<-chan *UpdateAnycastEipAddressAssociationsResponse, <-chan error) {
	responseChan := make(chan *UpdateAnycastEipAddressAssociationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAnycastEipAddressAssociations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAnycastEipAddressAssociationsWithCallback invokes the eipanycast.UpdateAnycastEipAddressAssociations API asynchronously
func (client *Client) UpdateAnycastEipAddressAssociationsWithCallback(request *UpdateAnycastEipAddressAssociationsRequest, callback func(response *UpdateAnycastEipAddressAssociationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAnycastEipAddressAssociationsResponse
		var err error
		defer close(result)
		response, err = client.UpdateAnycastEipAddressAssociations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAnycastEipAddressAssociationsRequest is the request struct for api UpdateAnycastEipAddressAssociations
type UpdateAnycastEipAddressAssociationsRequest struct {
	*requests.RpcRequest
	DryRun                requests.Boolean                                            `position:"Query" name:"DryRun"`
	AssociationMode       string                                                      `position:"Query" name:"AssociationMode"`
	ClientToken           string                                                      `position:"Query" name:"ClientToken"`
	PopLocationDeleteList *[]UpdateAnycastEipAddressAssociationsPopLocationDeleteList `position:"Query" name:"PopLocationDeleteList"  type:"Repeated"`
	AnycastId             string                                                      `position:"Query" name:"AnycastId"`
	PopLocationAddList    *[]UpdateAnycastEipAddressAssociationsPopLocationAddList    `position:"Query" name:"PopLocationAddList"  type:"Repeated"`
	BindInstanceId        string                                                      `position:"Query" name:"BindInstanceId"`
}

// UpdateAnycastEipAddressAssociationsPopLocationDeleteList is a repeated param struct in UpdateAnycastEipAddressAssociationsRequest
type UpdateAnycastEipAddressAssociationsPopLocationDeleteList struct {
	PopLocation string `name:"PopLocation"`
}

// UpdateAnycastEipAddressAssociationsPopLocationAddList is a repeated param struct in UpdateAnycastEipAddressAssociationsRequest
type UpdateAnycastEipAddressAssociationsPopLocationAddList struct {
	PopLocation string `name:"PopLocation"`
}

// UpdateAnycastEipAddressAssociationsResponse is the response struct for api UpdateAnycastEipAddressAssociations
type UpdateAnycastEipAddressAssociationsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateAnycastEipAddressAssociationsRequest creates a request to invoke UpdateAnycastEipAddressAssociations API
func CreateUpdateAnycastEipAddressAssociationsRequest() (request *UpdateAnycastEipAddressAssociationsRequest) {
	request = &UpdateAnycastEipAddressAssociationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Eipanycast", "2020-03-09", "UpdateAnycastEipAddressAssociations", "eipanycast", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateAnycastEipAddressAssociationsResponse creates a response to parse from UpdateAnycastEipAddressAssociations response
func CreateUpdateAnycastEipAddressAssociationsResponse() (response *UpdateAnycastEipAddressAssociationsResponse) {
	response = &UpdateAnycastEipAddressAssociationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
