package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelLogstashDeletion invokes the elasticsearch.CancelLogstashDeletion API synchronously
func (client *Client) CancelLogstashDeletion(request *CancelLogstashDeletionRequest) (response *CancelLogstashDeletionResponse, err error) {
	response = CreateCancelLogstashDeletionResponse()
	err = client.DoAction(request, response)
	return
}

// CancelLogstashDeletionWithChan invokes the elasticsearch.CancelLogstashDeletion API asynchronously
func (client *Client) CancelLogstashDeletionWithChan(request *CancelLogstashDeletionRequest) (<-chan *CancelLogstashDeletionResponse, <-chan error) {
	responseChan := make(chan *CancelLogstashDeletionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelLogstashDeletion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelLogstashDeletionWithCallback invokes the elasticsearch.CancelLogstashDeletion API asynchronously
func (client *Client) CancelLogstashDeletionWithCallback(request *CancelLogstashDeletionRequest, callback func(response *CancelLogstashDeletionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelLogstashDeletionResponse
		var err error
		defer close(result)
		response, err = client.CancelLogstashDeletion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelLogstashDeletionRequest is the request struct for api CancelLogstashDeletion
type CancelLogstashDeletionRequest struct {
	*requests.RoaRequest
	InstanceId  string `position:"Path" name:"InstanceId"`
	ClientToken string `position:"Query" name:"clientToken"`
}

// CancelLogstashDeletionResponse is the response struct for api CancelLogstashDeletion
type CancelLogstashDeletionResponse struct {
	*responses.BaseResponse
	Result    bool   `json:"Result" xml:"Result"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCancelLogstashDeletionRequest creates a request to invoke CancelLogstashDeletion API
func CreateCancelLogstashDeletionRequest() (request *CancelLogstashDeletionRequest) {
	request = &CancelLogstashDeletionRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "CancelLogstashDeletion", "/openapi/logstashes/[InstanceId]/actions/cancel-deletion", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCancelLogstashDeletionResponse creates a response to parse from CancelLogstashDeletion response
func CreateCancelLogstashDeletionResponse() (response *CancelLogstashDeletionResponse) {
	response = &CancelLogstashDeletionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
