package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDataStream invokes the elasticsearch.CreateDataStream API synchronously
func (client *Client) CreateDataStream(request *CreateDataStreamRequest) (response *CreateDataStreamResponse, err error) {
	response = CreateCreateDataStreamResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDataStreamWithChan invokes the elasticsearch.CreateDataStream API asynchronously
func (client *Client) CreateDataStreamWithChan(request *CreateDataStreamRequest) (<-chan *CreateDataStreamResponse, <-chan error) {
	responseChan := make(chan *CreateDataStreamResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDataStream(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDataStreamWithCallback invokes the elasticsearch.CreateDataStream API asynchronously
func (client *Client) CreateDataStreamWithCallback(request *CreateDataStreamRequest, callback func(response *CreateDataStreamResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDataStreamResponse
		var err error
		defer close(result)
		response, err = client.CreateDataStream(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDataStreamRequest is the request struct for api CreateDataStream
type CreateDataStreamRequest struct {
	*requests.RoaRequest
	InstanceId  string `position:"Path" name:"InstanceId"`
	ClientToken string `position:"Query" name:"ClientToken"`
	Body        string `position:"Body" name:"body"`
}

// CreateDataStreamResponse is the response struct for api CreateDataStream
type CreateDataStreamResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateCreateDataStreamRequest creates a request to invoke CreateDataStream API
func CreateCreateDataStreamRequest() (request *CreateDataStreamRequest) {
	request = &CreateDataStreamRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "CreateDataStream", "/openapi/instances/[InstanceId]/data-streams", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateDataStreamResponse creates a response to parse from CreateDataStream response
func CreateCreateDataStreamResponse() (response *CreateDataStreamResponse) {
	response = &CreateDataStreamResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
