package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDictInformation invokes the elasticsearch.ListDictInformation API synchronously
func (client *Client) ListDictInformation(request *ListDictInformationRequest) (response *ListDictInformationResponse, err error) {
	response = CreateListDictInformationResponse()
	err = client.DoAction(request, response)
	return
}

// ListDictInformationWithChan invokes the elasticsearch.ListDictInformation API asynchronously
func (client *Client) ListDictInformationWithChan(request *ListDictInformationRequest) (<-chan *ListDictInformationResponse, <-chan error) {
	responseChan := make(chan *ListDictInformationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDictInformation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDictInformationWithCallback invokes the elasticsearch.ListDictInformation API asynchronously
func (client *Client) ListDictInformationWithCallback(request *ListDictInformationRequest, callback func(response *ListDictInformationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDictInformationResponse
		var err error
		defer close(result)
		response, err = client.ListDictInformation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDictInformationRequest is the request struct for api ListDictInformation
type ListDictInformationRequest struct {
	*requests.RoaRequest
	InstanceId   string `position:"Path" name:"InstanceId"`
	AnalyzerType string `position:"Query" name:"analyzerType"`
	BucketName   string `position:"Query" name:"bucketName"`
	Key          string `position:"Query" name:"key"`
}

// ListDictInformationResponse is the response struct for api ListDictInformation
type ListDictInformationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateListDictInformationRequest creates a request to invoke ListDictInformation API
func CreateListDictInformationRequest() (request *ListDictInformationRequest) {
	request = &ListDictInformationRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "ListDictInformation", "/openapi/instances/[InstanceId]/dict/_info", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListDictInformationResponse creates a response to parse from ListDictInformation response
func CreateListDictInformationResponse() (response *ListDictInformationResponse) {
	response = &ListDictInformationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
