package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateComponentIndex invokes the elasticsearch.UpdateComponentIndex API synchronously
func (client *Client) UpdateComponentIndex(request *UpdateComponentIndexRequest) (response *UpdateComponentIndexResponse, err error) {
	response = CreateUpdateComponentIndexResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateComponentIndexWithChan invokes the elasticsearch.UpdateComponentIndex API asynchronously
func (client *Client) UpdateComponentIndexWithChan(request *UpdateComponentIndexRequest) (<-chan *UpdateComponentIndexResponse, <-chan error) {
	responseChan := make(chan *UpdateComponentIndexResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateComponentIndex(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateComponentIndexWithCallback invokes the elasticsearch.UpdateComponentIndex API asynchronously
func (client *Client) UpdateComponentIndexWithCallback(request *UpdateComponentIndexRequest, callback func(response *UpdateComponentIndexResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateComponentIndexResponse
		var err error
		defer close(result)
		response, err = client.UpdateComponentIndex(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateComponentIndexRequest is the request struct for api UpdateComponentIndex
type UpdateComponentIndexRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
	Name       string `position:"Path" name:"name"`
	Body       string `position:"Body" name:"body"`
}

// UpdateComponentIndexResponse is the response struct for api UpdateComponentIndex
type UpdateComponentIndexResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateUpdateComponentIndexRequest creates a request to invoke UpdateComponentIndex API
func CreateUpdateComponentIndexRequest() (request *UpdateComponentIndexRequest) {
	request = &UpdateComponentIndexRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "UpdateComponentIndex", "/openapi/instances/[InstanceId]/component-index/[name]", "elasticsearch", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateUpdateComponentIndexResponse creates a response to parse from UpdateComponentIndex response
func CreateUpdateComponentIndexResponse() (response *UpdateComponentIndexResponse) {
	response = &UpdateComponentIndexResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
