package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeployInstanceSDG invokes the ens.DeployInstanceSDG API synchronously
func (client *Client) DeployInstanceSDG(request *DeployInstanceSDGRequest) (response *DeployInstanceSDGResponse, err error) {
	response = CreateDeployInstanceSDGResponse()
	err = client.DoAction(request, response)
	return
}

// DeployInstanceSDGWithChan invokes the ens.DeployInstanceSDG API asynchronously
func (client *Client) DeployInstanceSDGWithChan(request *DeployInstanceSDGRequest) (<-chan *DeployInstanceSDGResponse, <-chan error) {
	responseChan := make(chan *DeployInstanceSDGResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeployInstanceSDG(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeployInstanceSDGWithCallback invokes the ens.DeployInstanceSDG API asynchronously
func (client *Client) DeployInstanceSDGWithCallback(request *DeployInstanceSDGRequest, callback func(response *DeployInstanceSDGResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeployInstanceSDGResponse
		var err error
		defer close(result)
		response, err = client.DeployInstanceSDG(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeployInstanceSDGRequest is the request struct for api DeployInstanceSDG
type DeployInstanceSDGRequest struct {
	*requests.RpcRequest
	DeploymentType string    `position:"Query" name:"DeploymentType"`
	SDGId          string    `position:"Query" name:"SDGId"`
	InstanceIds    *[]string `position:"Query" name:"InstanceIds"  type:"Json"`
}

// DeployInstanceSDGResponse is the response struct for api DeployInstanceSDG
type DeployInstanceSDGResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDeployInstanceSDGRequest creates a request to invoke DeployInstanceSDG API
func CreateDeployInstanceSDGRequest() (request *DeployInstanceSDGRequest) {
	request = &DeployInstanceSDGRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DeployInstanceSDG", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeployInstanceSDGResponse creates a response to parse from DeployInstanceSDG response
func CreateDeployInstanceSDGResponse() (response *DeployInstanceSDGResponse) {
	response = &DeployInstanceSDGResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
