package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEnsRouteTables invokes the ens.DescribeEnsRouteTables API synchronously
func (client *Client) DescribeEnsRouteTables(request *DescribeEnsRouteTablesRequest) (response *DescribeEnsRouteTablesResponse, err error) {
	response = CreateDescribeEnsRouteTablesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEnsRouteTablesWithChan invokes the ens.DescribeEnsRouteTables API asynchronously
func (client *Client) DescribeEnsRouteTablesWithChan(request *DescribeEnsRouteTablesRequest) (<-chan *DescribeEnsRouteTablesResponse, <-chan error) {
	responseChan := make(chan *DescribeEnsRouteTablesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEnsRouteTables(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEnsRouteTablesWithCallback invokes the ens.DescribeEnsRouteTables API asynchronously
func (client *Client) DescribeEnsRouteTablesWithCallback(request *DescribeEnsRouteTablesRequest, callback func(response *DescribeEnsRouteTablesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEnsRouteTablesResponse
		var err error
		defer close(result)
		response, err = client.DescribeEnsRouteTables(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEnsRouteTablesRequest is the request struct for api DescribeEnsRouteTables
type DescribeEnsRouteTablesRequest struct {
	*requests.RpcRequest
	Type           string           `position:"Query" name:"Type"`
	AssociateType  string           `position:"Query" name:"AssociateType"`
	EnsRegionId    string           `position:"Query" name:"EnsRegionId"`
	RouteTableId   string           `position:"Query" name:"RouteTableId"`
	NetworkId      string           `position:"Query" name:"NetworkId"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
	RouteTableName string           `position:"Query" name:"RouteTableName"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	EnsRegionIds   *[]string        `position:"Query" name:"EnsRegionIds"  type:"Repeated"`
}

// DescribeEnsRouteTablesResponse is the response struct for api DescribeEnsRouteTables
type DescribeEnsRouteTablesResponse struct {
	*responses.BaseResponse
	RequestId   string       `json:"RequestId" xml:"RequestId"`
	PageNumber  int          `json:"PageNumber" xml:"PageNumber"`
	TotalCount  int          `json:"TotalCount" xml:"TotalCount"`
	PageSize    int          `json:"PageSize" xml:"PageSize"`
	RouteTables []RouteTable `json:"RouteTables" xml:"RouteTables"`
}

// CreateDescribeEnsRouteTablesRequest creates a request to invoke DescribeEnsRouteTables API
func CreateDescribeEnsRouteTablesRequest() (request *DescribeEnsRouteTablesRequest) {
	request = &DescribeEnsRouteTablesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeEnsRouteTables", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeEnsRouteTablesResponse creates a response to parse from DescribeEnsRouteTables response
func CreateDescribeEnsRouteTablesResponse() (response *DescribeEnsRouteTablesResponse) {
	response = &DescribeEnsRouteTablesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
