package eventbridge

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateConnection invokes the eventbridge.CreateConnection API synchronously
func (client *Client) CreateConnection(request *CreateConnectionRequest) (response *CreateConnectionResponse, err error) {
	response = CreateCreateConnectionResponse()
	err = client.DoAction(request, response)
	return
}

// CreateConnectionWithChan invokes the eventbridge.CreateConnection API asynchronously
func (client *Client) CreateConnectionWithChan(request *CreateConnectionRequest) (<-chan *CreateConnectionResponse, <-chan error) {
	responseChan := make(chan *CreateConnectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateConnection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateConnectionWithCallback invokes the eventbridge.CreateConnection API asynchronously
func (client *Client) CreateConnectionWithCallback(request *CreateConnectionRequest, callback func(response *CreateConnectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateConnectionResponse
		var err error
		defer close(result)
		response, err = client.CreateConnection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateConnectionRequest is the request struct for api CreateConnection
type CreateConnectionRequest struct {
	*requests.RpcRequest
	ConnectionName    string                            `position:"Query" name:"ConnectionName"`
	Description       string                            `position:"Query" name:"Description"`
	NetworkParameters CreateConnectionNetworkParameters `position:"Query" name:"NetworkParameters"  type:"Struct"`
	AuthParameters    CreateConnectionAuthParameters    `position:"Query" name:"AuthParameters"  type:"Struct"`
}

// CreateConnectionNetworkParameters is a repeated param struct in CreateConnectionRequest
type CreateConnectionNetworkParameters struct {
	VpcId           string `name:"VpcId"`
	SecurityGroupId string `name:"SecurityGroupId"`
	NetworkType     string `name:"NetworkType"`
	VswitcheId      string `name:"VswitcheId"`
}

// CreateConnectionAuthParameters is a repeated param struct in CreateConnectionRequest
type CreateConnectionAuthParameters struct {
	BasicAuthParameters      CreateConnectionAuthParametersBasicAuthParameters      `name:"BasicAuthParameters" type:"Struct"`
	ApiKeyAuthParameters     CreateConnectionAuthParametersApiKeyAuthParameters     `name:"ApiKeyAuthParameters" type:"Struct"`
	AuthorizationType        string                                                 `name:"AuthorizationType"`
	InvocationHttpParameters CreateConnectionAuthParametersInvocationHttpParameters `name:"InvocationHttpParameters" type:"Struct"`
	OAuthParameters          CreateConnectionAuthParametersOAuthParameters          `name:"OAuthParameters" type:"Struct"`
}

// CreateConnectionAuthParametersBasicAuthParameters is a repeated param struct in CreateConnectionRequest
type CreateConnectionAuthParametersBasicAuthParameters struct {
	Password string `name:"Password"`
	Username string `name:"Username"`
}

// CreateConnectionAuthParametersApiKeyAuthParameters is a repeated param struct in CreateConnectionRequest
type CreateConnectionAuthParametersApiKeyAuthParameters struct {
	ApiKeyName  string `name:"ApiKeyName"`
	ApiKeyValue string `name:"ApiKeyValue"`
}

// CreateConnectionAuthParametersInvocationHttpParameters is a repeated param struct in CreateConnectionRequest
type CreateConnectionAuthParametersInvocationHttpParameters struct {
	BodyParameters        *[]CreateConnectionAuthParametersInvocationHttpParametersBodyParametersItem        `name:"BodyParameters" type:"Repeated"`
	HeaderParameters      *[]CreateConnectionAuthParametersInvocationHttpParametersHeaderParametersItem      `name:"HeaderParameters" type:"Repeated"`
	QueryStringParameters *[]CreateConnectionAuthParametersInvocationHttpParametersQueryStringParametersItem `name:"QueryStringParameters" type:"Repeated"`
}

// CreateConnectionAuthParametersOAuthParameters is a repeated param struct in CreateConnectionRequest
type CreateConnectionAuthParametersOAuthParameters struct {
	ClientParameters      CreateConnectionAuthParametersOAuthParametersClientParameters    `name:"ClientParameters" type:"Struct"`
	AuthorizationEndpoint string                                                           `name:"AuthorizationEndpoint"`
	HttpMethod            string                                                           `name:"HttpMethod"`
	OAuthHttpParameters   CreateConnectionAuthParametersOAuthParametersOAuthHttpParameters `name:"OAuthHttpParameters" type:"Struct"`
}

// CreateConnectionAuthParametersInvocationHttpParametersBodyParametersItem is a repeated param struct in CreateConnectionRequest
type CreateConnectionAuthParametersInvocationHttpParametersBodyParametersItem struct {
	IsValueSecret string `name:"IsValueSecret"`
	Value         string `name:"Value"`
	Key           string `name:"Key"`
}

// CreateConnectionAuthParametersInvocationHttpParametersHeaderParametersItem is a repeated param struct in CreateConnectionRequest
type CreateConnectionAuthParametersInvocationHttpParametersHeaderParametersItem struct {
	IsValueSecret string `name:"IsValueSecret"`
	Value         string `name:"Value"`
	Key           string `name:"Key"`
}

// CreateConnectionAuthParametersInvocationHttpParametersQueryStringParametersItem is a repeated param struct in CreateConnectionRequest
type CreateConnectionAuthParametersInvocationHttpParametersQueryStringParametersItem struct {
	IsValueSecret string `name:"IsValueSecret"`
	Value         string `name:"Value"`
	Key           string `name:"Key"`
}

// CreateConnectionAuthParametersOAuthParametersClientParameters is a repeated param struct in CreateConnectionRequest
type CreateConnectionAuthParametersOAuthParametersClientParameters struct {
	ClientID     string `name:"ClientID"`
	ClientSecret string `name:"ClientSecret"`
}

// CreateConnectionAuthParametersOAuthParametersOAuthHttpParameters is a repeated param struct in CreateConnectionRequest
type CreateConnectionAuthParametersOAuthParametersOAuthHttpParameters struct {
	BodyParameters        *[]CreateConnectionAuthParametersOAuthParametersOAuthHttpParametersBodyParametersItem        `name:"BodyParameters" type:"Repeated"`
	HeaderParameters      *[]CreateConnectionAuthParametersOAuthParametersOAuthHttpParametersHeaderParametersItem      `name:"HeaderParameters" type:"Repeated"`
	QueryStringParameters *[]CreateConnectionAuthParametersOAuthParametersOAuthHttpParametersQueryStringParametersItem `name:"QueryStringParameters" type:"Repeated"`
}

// CreateConnectionAuthParametersOAuthParametersOAuthHttpParametersBodyParametersItem is a repeated param struct in CreateConnectionRequest
type CreateConnectionAuthParametersOAuthParametersOAuthHttpParametersBodyParametersItem struct {
	IsValueSecret string `name:"IsValueSecret"`
	Value         string `name:"Value"`
	Key           string `name:"Key"`
}

// CreateConnectionAuthParametersOAuthParametersOAuthHttpParametersHeaderParametersItem is a repeated param struct in CreateConnectionRequest
type CreateConnectionAuthParametersOAuthParametersOAuthHttpParametersHeaderParametersItem struct {
	IsValueSecret string `name:"IsValueSecret"`
	Value         string `name:"Value"`
	Key           string `name:"Key"`
}

// CreateConnectionAuthParametersOAuthParametersOAuthHttpParametersQueryStringParametersItem is a repeated param struct in CreateConnectionRequest
type CreateConnectionAuthParametersOAuthParametersOAuthHttpParametersQueryStringParametersItem struct {
	IsValueSecret string `name:"IsValueSecret"`
	Value         string `name:"Value"`
	Key           string `name:"Key"`
}

// CreateConnectionResponse is the response struct for api CreateConnection
type CreateConnectionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateConnectionRequest creates a request to invoke CreateConnection API
func CreateCreateConnectionRequest() (request *CreateConnectionRequest) {
	request = &CreateConnectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eventbridge", "2020-04-01", "CreateConnection", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateConnectionResponse creates a response to parse from CreateConnection response
func CreateCreateConnectionResponse() (response *CreateConnectionResponse) {
	response = &CreateConnectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
