package eventbridge

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteEventBus invokes the eventbridge.DeleteEventBus API synchronously
func (client *Client) DeleteEventBus(request *DeleteEventBusRequest) (response *DeleteEventBusResponse, err error) {
	response = CreateDeleteEventBusResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteEventBusWithChan invokes the eventbridge.DeleteEventBus API asynchronously
func (client *Client) DeleteEventBusWithChan(request *DeleteEventBusRequest) (<-chan *DeleteEventBusResponse, <-chan error) {
	responseChan := make(chan *DeleteEventBusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteEventBus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteEventBusWithCallback invokes the eventbridge.DeleteEventBus API asynchronously
func (client *Client) DeleteEventBusWithCallback(request *DeleteEventBusRequest, callback func(response *DeleteEventBusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteEventBusResponse
		var err error
		defer close(result)
		response, err = client.DeleteEventBus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteEventBusRequest is the request struct for api DeleteEventBus
type DeleteEventBusRequest struct {
	*requests.RpcRequest
	ClientToken  string `position:"Query" name:"ClientToken"`
	EventBusName string `position:"Query" name:"EventBusName"`
}

// DeleteEventBusResponse is the response struct for api DeleteEventBus
type DeleteEventBusResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDeleteEventBusRequest creates a request to invoke DeleteEventBus API
func CreateDeleteEventBusRequest() (request *DeleteEventBusRequest) {
	request = &DeleteEventBusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eventbridge", "2020-04-01", "DeleteEventBus", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteEventBusResponse creates a response to parse from DeleteEventBus response
func CreateDeleteEventBusResponse() (response *DeleteEventBusResponse) {
	response = &DeleteEventBusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
