package facebody

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BeautifyBody invokes the facebody.BeautifyBody API synchronously
func (client *Client) BeautifyBody(request *BeautifyBodyRequest) (response *BeautifyBodyResponse, err error) {
	response = CreateBeautifyBodyResponse()
	err = client.DoAction(request, response)
	return
}

// BeautifyBodyWithChan invokes the facebody.BeautifyBody API asynchronously
func (client *Client) BeautifyBodyWithChan(request *BeautifyBodyRequest) (<-chan *BeautifyBodyResponse, <-chan error) {
	responseChan := make(chan *BeautifyBodyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BeautifyBody(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BeautifyBodyWithCallback invokes the facebody.BeautifyBody API asynchronously
func (client *Client) BeautifyBodyWithCallback(request *BeautifyBodyRequest, callback func(response *BeautifyBodyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BeautifyBodyResponse
		var err error
		defer close(result)
		response, err = client.BeautifyBody(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BeautifyBodyRequest is the request struct for api BeautifyBody
type BeautifyBodyRequest struct {
	*requests.RpcRequest
	BodyBoxes           *[]BeautifyBodyBodyBoxes `position:"Body" name:"BodyBoxes"  type:"Json"`
	LengthenDegree      requests.Float           `position:"Body" name:"LengthenDegree"`
	MaleLiquifyDegree   requests.Float           `position:"Body" name:"MaleLiquifyDegree"`
	FormatResultToJson  requests.Boolean         `position:"Query" name:"FormatResultToJson"`
	OriginalWidth       requests.Integer         `position:"Body" name:"OriginalWidth"`
	IsPregnant          requests.Boolean         `position:"Body" name:"IsPregnant"`
	FaceList            *[]BeautifyBodyFaceList  `position:"Body" name:"FaceList"  type:"Json"`
	OssFile             string                   `position:"Query" name:"OssFile"`
	AgeRange            BeautifyBodyAgeRange     `position:"Body" name:"AgeRange"  type:"Struct"`
	Custom              requests.Integer         `position:"Body" name:"Custom"`
	RequestProxyBy      string                   `position:"Query" name:"RequestProxyBy"`
	OriginalHeight      requests.Integer         `position:"Body" name:"OriginalHeight"`
	ImageURL            string                   `position:"Body" name:"ImageURL"`
	FemaleLiquifyDegree requests.Float           `position:"Body" name:"FemaleLiquifyDegree"`
	PoseList            *[]BeautifyBodyPoseList  `position:"Body" name:"PoseList"  type:"Json"`
}

// BeautifyBodyBodyBoxes is a repeated param struct in BeautifyBodyRequest
type BeautifyBodyBodyBoxes struct {
	X      string `name:"X"`
	Width  string `name:"Width"`
	Y      string `name:"Y"`
	Height string `name:"Height"`
}

// BeautifyBodyFaceList is a repeated param struct in BeautifyBodyRequest
type BeautifyBodyFaceList struct {
	Gender  string                      `name:"Gender"`
	FaceBox BeautifyBodyFaceListFaceBox `name:"FaceBox" type:"Struct"`
	Age     string                      `name:"Age"`
}

// BeautifyBodyPoseList is a repeated param struct in BeautifyBodyRequest
type BeautifyBodyPoseList struct {
	Pose *[]BeautifyBodyPoseListPoseItem `name:"Pose" type:"Repeated"`
}

// BeautifyBodyFaceListFaceBox is a repeated param struct in BeautifyBodyRequest
type BeautifyBodyFaceListFaceBox struct {
	X      string `name:"X"`
	Width  string `name:"Width"`
	Y      string `name:"Y"`
	Height string `name:"Height"`
}

// BeautifyBodyPoseListPoseItem is a repeated param struct in BeautifyBodyRequest
type BeautifyBodyPoseListPoseItem struct {
	Score string `name:"Score"`
	X     string `name:"X"`
	Y     string `name:"Y"`
}

// BeautifyBodyAgeRange is a repeated param struct in BeautifyBodyRequest
type BeautifyBodyAgeRange struct {
	AgeMax     string `name:"AgeMax"`
	AgeMinimum string `name:"AgeMinimum"`
}

// BeautifyBodyResponse is the response struct for api BeautifyBody
type BeautifyBodyResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateBeautifyBodyRequest creates a request to invoke BeautifyBody API
func CreateBeautifyBodyRequest() (request *BeautifyBodyRequest) {
	request = &BeautifyBodyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("facebody", "2019-12-30", "BeautifyBody", "facebody", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBeautifyBodyResponse creates a response to parse from BeautifyBody response
func CreateBeautifyBodyResponse() (response *BeautifyBodyResponse) {
	response = &BeautifyBodyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
