package governance

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAccountFactoryBaseline invokes the governance.DeleteAccountFactoryBaseline API synchronously
func (client *Client) DeleteAccountFactoryBaseline(request *DeleteAccountFactoryBaselineRequest) (response *DeleteAccountFactoryBaselineResponse, err error) {
	response = CreateDeleteAccountFactoryBaselineResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAccountFactoryBaselineWithChan invokes the governance.DeleteAccountFactoryBaseline API asynchronously
func (client *Client) DeleteAccountFactoryBaselineWithChan(request *DeleteAccountFactoryBaselineRequest) (<-chan *DeleteAccountFactoryBaselineResponse, <-chan error) {
	responseChan := make(chan *DeleteAccountFactoryBaselineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAccountFactoryBaseline(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAccountFactoryBaselineWithCallback invokes the governance.DeleteAccountFactoryBaseline API asynchronously
func (client *Client) DeleteAccountFactoryBaselineWithCallback(request *DeleteAccountFactoryBaselineRequest, callback func(response *DeleteAccountFactoryBaselineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAccountFactoryBaselineResponse
		var err error
		defer close(result)
		response, err = client.DeleteAccountFactoryBaseline(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAccountFactoryBaselineRequest is the request struct for api DeleteAccountFactoryBaseline
type DeleteAccountFactoryBaselineRequest struct {
	*requests.RpcRequest
	BaselineId string `position:"Query" name:"BaselineId"`
}

// DeleteAccountFactoryBaselineResponse is the response struct for api DeleteAccountFactoryBaseline
type DeleteAccountFactoryBaselineResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteAccountFactoryBaselineRequest creates a request to invoke DeleteAccountFactoryBaseline API
func CreateDeleteAccountFactoryBaselineRequest() (request *DeleteAccountFactoryBaselineRequest) {
	request = &DeleteAccountFactoryBaselineRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("governance", "2021-01-20", "DeleteAccountFactoryBaseline", "governance", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteAccountFactoryBaselineResponse creates a response to parse from DeleteAccountFactoryBaseline response
func CreateDeleteAccountFactoryBaselineResponse() (response *DeleteAccountFactoryBaselineResponse) {
	response = &DeleteAccountFactoryBaselineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
