package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DownloadSQLLogsRecords invokes the gpdb.DownloadSQLLogsRecords API synchronously
func (client *Client) DownloadSQLLogsRecords(request *DownloadSQLLogsRecordsRequest) (response *DownloadSQLLogsRecordsResponse, err error) {
	response = CreateDownloadSQLLogsRecordsResponse()
	err = client.DoAction(request, response)
	return
}

// DownloadSQLLogsRecordsWithChan invokes the gpdb.DownloadSQLLogsRecords API asynchronously
func (client *Client) DownloadSQLLogsRecordsWithChan(request *DownloadSQLLogsRecordsRequest) (<-chan *DownloadSQLLogsRecordsResponse, <-chan error) {
	responseChan := make(chan *DownloadSQLLogsRecordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DownloadSQLLogsRecords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DownloadSQLLogsRecordsWithCallback invokes the gpdb.DownloadSQLLogsRecords API asynchronously
func (client *Client) DownloadSQLLogsRecordsWithCallback(request *DownloadSQLLogsRecordsRequest, callback func(response *DownloadSQLLogsRecordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DownloadSQLLogsRecordsResponse
		var err error
		defer close(result)
		response, err = client.DownloadSQLLogsRecords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DownloadSQLLogsRecordsRequest is the request struct for api DownloadSQLLogsRecords
type DownloadSQLLogsRecordsRequest struct {
	*requests.RpcRequest
	StartTime      string           `position:"Query" name:"StartTime"`
	QueryKeywords  string           `position:"Query" name:"QueryKeywords"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
	Database       string           `position:"Query" name:"Database"`
	SourceIP       string           `position:"Query" name:"SourceIP"`
	MinExecuteCost string           `position:"Query" name:"MinExecuteCost"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	DBInstanceId   string           `position:"Query" name:"DBInstanceId"`
	Lang           string           `position:"Query" name:"Lang"`
	MaxExecuteCost string           `position:"Query" name:"MaxExecuteCost"`
	ExecuteCost    string           `position:"Query" name:"ExecuteCost"`
	ExecuteState   string           `position:"Query" name:"ExecuteState"`
	EndTime        string           `position:"Query" name:"EndTime"`
	OperationType  string           `position:"Query" name:"OperationType"`
	OperationClass string           `position:"Query" name:"OperationClass"`
	User           string           `position:"Query" name:"User"`
}

// DownloadSQLLogsRecordsResponse is the response struct for api DownloadSQLLogsRecords
type DownloadSQLLogsRecordsResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	DownloadId int64  `json:"DownloadId" xml:"DownloadId"`
}

// CreateDownloadSQLLogsRecordsRequest creates a request to invoke DownloadSQLLogsRecords API
func CreateDownloadSQLLogsRecordsRequest() (request *DownloadSQLLogsRecordsRequest) {
	request = &DownloadSQLLogsRecordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "DownloadSQLLogsRecords", "", "")
	request.Method = requests.POST
	return
}

// CreateDownloadSQLLogsRecordsResponse creates a response to parse from DownloadSQLLogsRecords response
func CreateDownloadSQLLogsRecordsResponse() (response *DownloadSQLLogsRecordsResponse) {
	response = &DownloadSQLLogsRecordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
