package gwlb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateLoadBalancer invokes the gwlb.CreateLoadBalancer API synchronously
func (client *Client) CreateLoadBalancer(request *CreateLoadBalancerRequest) (response *CreateLoadBalancerResponse, err error) {
	response = CreateCreateLoadBalancerResponse()
	err = client.DoAction(request, response)
	return
}

// CreateLoadBalancerWithChan invokes the gwlb.CreateLoadBalancer API asynchronously
func (client *Client) CreateLoadBalancerWithChan(request *CreateLoadBalancerRequest) (<-chan *CreateLoadBalancerResponse, <-chan error) {
	responseChan := make(chan *CreateLoadBalancerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateLoadBalancer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateLoadBalancerWithCallback invokes the gwlb.CreateLoadBalancer API asynchronously
func (client *Client) CreateLoadBalancerWithCallback(request *CreateLoadBalancerRequest, callback func(response *CreateLoadBalancerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateLoadBalancerResponse
		var err error
		defer close(result)
		response, err = client.CreateLoadBalancer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateLoadBalancerRequest is the request struct for api CreateLoadBalancer
type CreateLoadBalancerRequest struct {
	*requests.RpcRequest
	CrossZoneEnabled requests.Boolean                  `position:"Body" name:"CrossZoneEnabled"`
	ClientToken      string                            `position:"Body" name:"ClientToken"`
	AddressIpVersion string                            `position:"Body" name:"AddressIpVersion"`
	ResourceGroupId  string                            `position:"Body" name:"ResourceGroupId"`
	LoadBalancerName string                            `position:"Body" name:"LoadBalancerName"`
	Tag              *[]CreateLoadBalancerTag          `position:"Body" name:"Tag"  type:"Repeated"`
	DryRun           requests.Boolean                  `position:"Body" name:"DryRun"`
	ZoneMappings     *[]CreateLoadBalancerZoneMappings `position:"Body" name:"ZoneMappings"  type:"Repeated"`
	VpcId            string                            `position:"Body" name:"VpcId"`
}

// CreateLoadBalancerTag is a repeated param struct in CreateLoadBalancerRequest
type CreateLoadBalancerTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// CreateLoadBalancerZoneMappings is a repeated param struct in CreateLoadBalancerRequest
type CreateLoadBalancerZoneMappings struct {
	VSwitchId string `name:"VSwitchId"`
	ZoneId    string `name:"ZoneId"`
}

// CreateLoadBalancerResponse is the response struct for api CreateLoadBalancer
type CreateLoadBalancerResponse struct {
	*responses.BaseResponse
	LoadBalancerId string `json:"LoadBalancerId" xml:"LoadBalancerId"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateLoadBalancerRequest creates a request to invoke CreateLoadBalancer API
func CreateCreateLoadBalancerRequest() (request *CreateLoadBalancerRequest) {
	request = &CreateLoadBalancerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Gwlb", "2024-04-15", "CreateLoadBalancer", "gwlb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateLoadBalancerResponse creates a response to parse from CreateLoadBalancer response
func CreateCreateLoadBalancerResponse() (response *CreateLoadBalancerResponse) {
	response = &CreateLoadBalancerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
