package hitsdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SwitchLSQLV3MySQLService invokes the hitsdb.SwitchLSQLV3MySQLService API synchronously
func (client *Client) SwitchLSQLV3MySQLService(request *SwitchLSQLV3MySQLServiceRequest) (response *SwitchLSQLV3MySQLServiceResponse, err error) {
	response = CreateSwitchLSQLV3MySQLServiceResponse()
	err = client.DoAction(request, response)
	return
}

// SwitchLSQLV3MySQLServiceWithChan invokes the hitsdb.SwitchLSQLV3MySQLService API asynchronously
func (client *Client) SwitchLSQLV3MySQLServiceWithChan(request *SwitchLSQLV3MySQLServiceRequest) (<-chan *SwitchLSQLV3MySQLServiceResponse, <-chan error) {
	responseChan := make(chan *SwitchLSQLV3MySQLServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SwitchLSQLV3MySQLService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SwitchLSQLV3MySQLServiceWithCallback invokes the hitsdb.SwitchLSQLV3MySQLService API asynchronously
func (client *Client) SwitchLSQLV3MySQLServiceWithCallback(request *SwitchLSQLV3MySQLServiceRequest, callback func(response *SwitchLSQLV3MySQLServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SwitchLSQLV3MySQLServiceResponse
		var err error
		defer close(result)
		response, err = client.SwitchLSQLV3MySQLService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SwitchLSQLV3MySQLServiceRequest is the request struct for api SwitchLSQLV3MySQLService
type SwitchLSQLV3MySQLServiceRequest struct {
	*requests.RpcRequest
	ActionType           requests.Integer `position:"Query" name:"ActionType"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
}

// SwitchLSQLV3MySQLServiceResponse is the response struct for api SwitchLSQLV3MySQLService
type SwitchLSQLV3MySQLServiceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSwitchLSQLV3MySQLServiceRequest creates a request to invoke SwitchLSQLV3MySQLService API
func CreateSwitchLSQLV3MySQLServiceRequest() (request *SwitchLSQLV3MySQLServiceRequest) {
	request = &SwitchLSQLV3MySQLServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("hitsdb", "2020-06-15", "SwitchLSQLV3MySQLService", "hitsdb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSwitchLSQLV3MySQLServiceResponse creates a response to parse from SwitchLSQLV3MySQLService response
func CreateSwitchLSQLV3MySQLServiceResponse() (response *SwitchLSQLV3MySQLServiceResponse) {
	response = &SwitchLSQLV3MySQLServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
