package idaas_doraemon

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySmsUps invokes the idaas_doraemon.QuerySmsUps API synchronously
func (client *Client) QuerySmsUps(request *QuerySmsUpsRequest) (response *QuerySmsUpsResponse, err error) {
	response = CreateQuerySmsUpsResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySmsUpsWithChan invokes the idaas_doraemon.QuerySmsUps API asynchronously
func (client *Client) QuerySmsUpsWithChan(request *QuerySmsUpsRequest) (<-chan *QuerySmsUpsResponse, <-chan error) {
	responseChan := make(chan *QuerySmsUpsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySmsUps(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySmsUpsWithCallback invokes the idaas_doraemon.QuerySmsUps API asynchronously
func (client *Client) QuerySmsUpsWithCallback(request *QuerySmsUpsRequest, callback func(response *QuerySmsUpsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySmsUpsResponse
		var err error
		defer close(result)
		response, err = client.QuerySmsUps(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySmsUpsRequest is the request struct for api QuerySmsUps
type QuerySmsUpsRequest struct {
	*requests.RpcRequest
}

// QuerySmsUpsResponse is the response struct for api QuerySmsUps
type QuerySmsUpsResponse struct {
	*responses.BaseResponse
	RequestId     string       `json:"RequestId" xml:"RequestId"`
	TotalElements int64        `json:"TotalElements" xml:"TotalElements"`
	SmsUps        []SmsUpsItem `json:"SmsUps" xml:"SmsUps"`
}

// CreateQuerySmsUpsRequest creates a request to invoke QuerySmsUps API
func CreateQuerySmsUpsRequest() (request *QuerySmsUpsRequest) {
	request = &QuerySmsUpsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idaas-doraemon", "2021-05-20", "QuerySmsUps", "idaasauth", "openAPI")
	request.Method = requests.GET
	return
}

// CreateQuerySmsUpsResponse creates a response to parse from QuerySmsUps response
func CreateQuerySmsUpsResponse() (response *QuerySmsUpsResponse) {
	response = &QuerySmsUpsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
