package imageprocess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetectCovid19Cad invokes the imageprocess.DetectCovid19Cad API synchronously
func (client *Client) DetectCovid19Cad(request *DetectCovid19CadRequest) (response *DetectCovid19CadResponse, err error) {
	response = CreateDetectCovid19CadResponse()
	err = client.DoAction(request, response)
	return
}

// DetectCovid19CadWithChan invokes the imageprocess.DetectCovid19Cad API asynchronously
func (client *Client) DetectCovid19CadWithChan(request *DetectCovid19CadRequest) (<-chan *DetectCovid19CadResponse, <-chan error) {
	responseChan := make(chan *DetectCovid19CadResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetectCovid19Cad(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetectCovid19CadWithCallback invokes the imageprocess.DetectCovid19Cad API asynchronously
func (client *Client) DetectCovid19CadWithCallback(request *DetectCovid19CadRequest, callback func(response *DetectCovid19CadResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetectCovid19CadResponse
		var err error
		defer close(result)
		response, err = client.DetectCovid19Cad(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetectCovid19CadRequest is the request struct for api DetectCovid19Cad
type DetectCovid19CadRequest struct {
	*requests.RpcRequest
	OrgName    string                     `position:"Body" name:"OrgName"`
	DataFormat string                     `position:"Body" name:"DataFormat"`
	URLList    *[]DetectCovid19CadURLList `position:"Body" name:"URLList"  type:"Repeated"`
	OrgId      string                     `position:"Body" name:"OrgId"`
	Async      requests.Boolean           `position:"Body" name:"Async"`
}

// DetectCovid19CadURLList is a repeated param struct in DetectCovid19CadRequest
type DetectCovid19CadURLList struct {
	URL string `name:"URL"`
}

// DetectCovid19CadResponse is the response struct for api DetectCovid19Cad
type DetectCovid19CadResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDetectCovid19CadRequest creates a request to invoke DetectCovid19Cad API
func CreateDetectCovid19CadRequest() (request *DetectCovid19CadRequest) {
	request = &DetectCovid19CadRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageprocess", "2020-03-20", "DetectCovid19Cad", "imageprocess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetectCovid19CadResponse creates a response to parse from DetectCovid19Cad response
func CreateDetectCovid19CadResponse() (response *DetectCovid19CadResponse) {
	response = &DetectCovid19CadResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
