package ims

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAccountSummary invokes the ims.GetAccountSummary API synchronously
func (client *Client) GetAccountSummary(request *GetAccountSummaryRequest) (response *GetAccountSummaryResponse, err error) {
	response = CreateGetAccountSummaryResponse()
	err = client.DoAction(request, response)
	return
}

// GetAccountSummaryWithChan invokes the ims.GetAccountSummary API asynchronously
func (client *Client) GetAccountSummaryWithChan(request *GetAccountSummaryRequest) (<-chan *GetAccountSummaryResponse, <-chan error) {
	responseChan := make(chan *GetAccountSummaryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAccountSummary(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAccountSummaryWithCallback invokes the ims.GetAccountSummary API asynchronously
func (client *Client) GetAccountSummaryWithCallback(request *GetAccountSummaryRequest, callback func(response *GetAccountSummaryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAccountSummaryResponse
		var err error
		defer close(result)
		response, err = client.GetAccountSummary(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAccountSummaryRequest is the request struct for api GetAccountSummary
type GetAccountSummaryRequest struct {
	*requests.RpcRequest
	AkProxySuffix string `position:"Query" name:"AkProxySuffix"`
}

// GetAccountSummaryResponse is the response struct for api GetAccountSummary
type GetAccountSummaryResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	SummaryMap SummaryMap `json:"SummaryMap" xml:"SummaryMap"`
}

// CreateGetAccountSummaryRequest creates a request to invoke GetAccountSummary API
func CreateGetAccountSummaryRequest() (request *GetAccountSummaryRequest) {
	request = &GetAccountSummaryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ims", "2019-08-15", "GetAccountSummary", "ims", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetAccountSummaryResponse creates a response to parse from GetAccountSummary response
func CreateGetAccountSummaryResponse() (response *GetAccountSummaryResponse) {
	response = &GetAccountSummaryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
