package ims

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAppSecret invokes the ims.GetAppSecret API synchronously
func (client *Client) GetAppSecret(request *GetAppSecretRequest) (response *GetAppSecretResponse, err error) {
	response = CreateGetAppSecretResponse()
	err = client.DoAction(request, response)
	return
}

// GetAppSecretWithChan invokes the ims.GetAppSecret API asynchronously
func (client *Client) GetAppSecretWithChan(request *GetAppSecretRequest) (<-chan *GetAppSecretResponse, <-chan error) {
	responseChan := make(chan *GetAppSecretResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAppSecret(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAppSecretWithCallback invokes the ims.GetAppSecret API asynchronously
func (client *Client) GetAppSecretWithCallback(request *GetAppSecretRequest, callback func(response *GetAppSecretResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAppSecretResponse
		var err error
		defer close(result)
		response, err = client.GetAppSecret(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAppSecretRequest is the request struct for api GetAppSecret
type GetAppSecretRequest struct {
	*requests.RpcRequest
	AkProxySuffix string `position:"Query" name:"AkProxySuffix"`
	AppSecretId   string `position:"Query" name:"AppSecretId"`
	AppId         string `position:"Query" name:"AppId"`
}

// GetAppSecretResponse is the response struct for api GetAppSecret
type GetAppSecretResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	AppSecret AppSecret `json:"AppSecret" xml:"AppSecret"`
}

// CreateGetAppSecretRequest creates a request to invoke GetAppSecret API
func CreateGetAppSecretRequest() (request *GetAppSecretRequest) {
	request = &GetAppSecretRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ims", "2019-08-15", "GetAppSecret", "ims", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetAppSecretResponse creates a response to parse from GetAppSecret response
func CreateGetAppSecretResponse() (response *GetAppSecretResponse) {
	response = &GetAppSecretResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
