package ims

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateLoginProfile invokes the ims.UpdateLoginProfile API synchronously
func (client *Client) UpdateLoginProfile(request *UpdateLoginProfileRequest) (response *UpdateLoginProfileResponse, err error) {
	response = CreateUpdateLoginProfileResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateLoginProfileWithChan invokes the ims.UpdateLoginProfile API asynchronously
func (client *Client) UpdateLoginProfileWithChan(request *UpdateLoginProfileRequest) (<-chan *UpdateLoginProfileResponse, <-chan error) {
	responseChan := make(chan *UpdateLoginProfileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateLoginProfile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateLoginProfileWithCallback invokes the ims.UpdateLoginProfile API asynchronously
func (client *Client) UpdateLoginProfileWithCallback(request *UpdateLoginProfileRequest, callback func(response *UpdateLoginProfileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateLoginProfileResponse
		var err error
		defer close(result)
		response, err = client.UpdateLoginProfile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateLoginProfileRequest is the request struct for api UpdateLoginProfile
type UpdateLoginProfileRequest struct {
	*requests.RpcRequest
	AkProxySuffix          string           `position:"Query" name:"AkProxySuffix"`
	Password               string           `position:"Query" name:"Password"`
	GenerateRandomPassword requests.Boolean `position:"Query" name:"GenerateRandomPassword"`
	MFABindRequired        requests.Boolean `position:"Query" name:"MFABindRequired"`
	PasswordResetRequired  requests.Boolean `position:"Query" name:"PasswordResetRequired"`
	UserPrincipalName      string           `position:"Query" name:"UserPrincipalName"`
	Status                 string           `position:"Query" name:"Status"`
}

// UpdateLoginProfileResponse is the response struct for api UpdateLoginProfile
type UpdateLoginProfileResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	LoginProfile LoginProfile `json:"LoginProfile" xml:"LoginProfile"`
}

// CreateUpdateLoginProfileRequest creates a request to invoke UpdateLoginProfile API
func CreateUpdateLoginProfileRequest() (request *UpdateLoginProfileRequest) {
	request = &UpdateLoginProfileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ims", "2019-08-15", "UpdateLoginProfile", "ims", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateLoginProfileResponse creates a response to parse from UpdateLoginProfile response
func CreateUpdateLoginProfileResponse() (response *UpdateLoginProfileResponse) {
	response = &UpdateLoginProfileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
