package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableDeviceTunnel invokes the iot.DisableDeviceTunnel API synchronously
func (client *Client) DisableDeviceTunnel(request *DisableDeviceTunnelRequest) (response *DisableDeviceTunnelResponse, err error) {
	response = CreateDisableDeviceTunnelResponse()
	err = client.DoAction(request, response)
	return
}

// DisableDeviceTunnelWithChan invokes the iot.DisableDeviceTunnel API asynchronously
func (client *Client) DisableDeviceTunnelWithChan(request *DisableDeviceTunnelRequest) (<-chan *DisableDeviceTunnelResponse, <-chan error) {
	responseChan := make(chan *DisableDeviceTunnelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableDeviceTunnel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableDeviceTunnelWithCallback invokes the iot.DisableDeviceTunnel API asynchronously
func (client *Client) DisableDeviceTunnelWithCallback(request *DisableDeviceTunnelRequest, callback func(response *DisableDeviceTunnelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableDeviceTunnelResponse
		var err error
		defer close(result)
		response, err = client.DisableDeviceTunnel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableDeviceTunnelRequest is the request struct for api DisableDeviceTunnel
type DisableDeviceTunnelRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ProductKey    string `position:"Query" name:"ProductKey"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
	DeviceName    string `position:"Query" name:"DeviceName"`
}

// DisableDeviceTunnelResponse is the response struct for api DisableDeviceTunnel
type DisableDeviceTunnelResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateDisableDeviceTunnelRequest creates a request to invoke DisableDeviceTunnel API
func CreateDisableDeviceTunnelRequest() (request *DisableDeviceTunnelRequest) {
	request = &DisableDeviceTunnelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "DisableDeviceTunnel", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDisableDeviceTunnelResponse creates a response to parse from DisableDeviceTunnel response
func CreateDisableDeviceTunnelResponse() (response *DisableDeviceTunnelResponse) {
	response = &DisableDeviceTunnelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
