package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyPowerStation invokes the iot.ModifyPowerStation API synchronously
func (client *Client) ModifyPowerStation(request *ModifyPowerStationRequest) (response *ModifyPowerStationResponse, err error) {
	response = CreateModifyPowerStationResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyPowerStationWithChan invokes the iot.ModifyPowerStation API asynchronously
func (client *Client) ModifyPowerStationWithChan(request *ModifyPowerStationRequest) (<-chan *ModifyPowerStationResponse, <-chan error) {
	responseChan := make(chan *ModifyPowerStationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyPowerStation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyPowerStationWithCallback invokes the iot.ModifyPowerStation API asynchronously
func (client *Client) ModifyPowerStationWithCallback(request *ModifyPowerStationRequest, callback func(response *ModifyPowerStationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyPowerStationResponse
		var err error
		defer close(result)
		response, err = client.ModifyPowerStation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyPowerStationRequest is the request struct for api ModifyPowerStation
type ModifyPowerStationRequest struct {
	*requests.RpcRequest
	PowerStationUid      string           `position:"Query" name:"PowerStationUid"`
	RatedPower           requests.Integer `position:"Query" name:"RatedPower"`
	Description          string           `position:"Query" name:"Description"`
	IotInstanceId        string           `position:"Query" name:"IotInstanceId"`
	AlgorithmInstanceUid string           `position:"Query" name:"AlgorithmInstanceUid"`
	PowerStationName     string           `position:"Query" name:"PowerStationName"`
	ApiProduct           string           `position:"Body" name:"ApiProduct"`
	ApiRevision          string           `position:"Body" name:"ApiRevision"`
}

// ModifyPowerStationResponse is the response struct for api ModifyPowerStation
type ModifyPowerStationResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         string `json:"Data" xml:"Data"`
}

// CreateModifyPowerStationRequest creates a request to invoke ModifyPowerStation API
func CreateModifyPowerStationRequest() (request *ModifyPowerStationRequest) {
	request = &ModifyPowerStationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "ModifyPowerStation", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyPowerStationResponse creates a response to parse from ModifyPowerStation response
func CreateModifyPowerStationResponse() (response *ModifyPowerStationResponse) {
	response = &ModifyPowerStationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
