package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PublishThingModelAsyncInner invokes the iot.PublishThingModelAsyncInner API synchronously
func (client *Client) PublishThingModelAsyncInner(request *PublishThingModelAsyncInnerRequest) (response *PublishThingModelAsyncInnerResponse, err error) {
	response = CreatePublishThingModelAsyncInnerResponse()
	err = client.DoAction(request, response)
	return
}

// PublishThingModelAsyncInnerWithChan invokes the iot.PublishThingModelAsyncInner API asynchronously
func (client *Client) PublishThingModelAsyncInnerWithChan(request *PublishThingModelAsyncInnerRequest) (<-chan *PublishThingModelAsyncInnerResponse, <-chan error) {
	responseChan := make(chan *PublishThingModelAsyncInnerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PublishThingModelAsyncInner(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PublishThingModelAsyncInnerWithCallback invokes the iot.PublishThingModelAsyncInner API asynchronously
func (client *Client) PublishThingModelAsyncInnerWithCallback(request *PublishThingModelAsyncInnerRequest, callback func(response *PublishThingModelAsyncInnerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PublishThingModelAsyncInnerResponse
		var err error
		defer close(result)
		response, err = client.PublishThingModelAsyncInner(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PublishThingModelAsyncInnerRequest is the request struct for api PublishThingModelAsyncInner
type PublishThingModelAsyncInnerRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ProductKey    string `position:"Query" name:"ProductKey"`
	InsId         string `position:"Query" name:"InsId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// PublishThingModelAsyncInnerResponse is the response struct for api PublishThingModelAsyncInner
type PublishThingModelAsyncInnerResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Message      string `json:"Message" xml:"Message"`
	Code         int    `json:"Code" xml:"Code"`
	LocalizedMsg string `json:"LocalizedMsg" xml:"LocalizedMsg"`
}

// CreatePublishThingModelAsyncInnerRequest creates a request to invoke PublishThingModelAsyncInner API
func CreatePublishThingModelAsyncInnerRequest() (request *PublishThingModelAsyncInnerRequest) {
	request = &PublishThingModelAsyncInnerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "PublishThingModelAsyncInner", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePublishThingModelAsyncInnerResponse creates a response to parse from PublishThingModelAsyncInner response
func CreatePublishThingModelAsyncInnerResponse() (response *PublishThingModelAsyncInnerResponse) {
	response = &PublishThingModelAsyncInnerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
