package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryDeviceDistributeJob invokes the iot.QueryDeviceDistributeJob API synchronously
func (client *Client) QueryDeviceDistributeJob(request *QueryDeviceDistributeJobRequest) (response *QueryDeviceDistributeJobResponse, err error) {
	response = CreateQueryDeviceDistributeJobResponse()
	err = client.DoAction(request, response)
	return
}

// QueryDeviceDistributeJobWithChan invokes the iot.QueryDeviceDistributeJob API asynchronously
func (client *Client) QueryDeviceDistributeJobWithChan(request *QueryDeviceDistributeJobRequest) (<-chan *QueryDeviceDistributeJobResponse, <-chan error) {
	responseChan := make(chan *QueryDeviceDistributeJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryDeviceDistributeJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryDeviceDistributeJobWithCallback invokes the iot.QueryDeviceDistributeJob API asynchronously
func (client *Client) QueryDeviceDistributeJobWithCallback(request *QueryDeviceDistributeJobRequest, callback func(response *QueryDeviceDistributeJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryDeviceDistributeJobResponse
		var err error
		defer close(result)
		response, err = client.QueryDeviceDistributeJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryDeviceDistributeJobRequest is the request struct for api QueryDeviceDistributeJob
type QueryDeviceDistributeJobRequest struct {
	*requests.RpcRequest
	JobId       string `position:"Query" name:"JobId"`
	ApiProduct  string `position:"Body" name:"ApiProduct"`
	ApiRevision string `position:"Body" name:"ApiRevision"`
}

// QueryDeviceDistributeJobResponse is the response struct for api QueryDeviceDistributeJob
type QueryDeviceDistributeJobResponse struct {
	*responses.BaseResponse
	RequestId    string                         `json:"RequestId" xml:"RequestId"`
	Success      bool                           `json:"Success" xml:"Success"`
	Code         string                         `json:"Code" xml:"Code"`
	ErrorMessage string                         `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInQueryDeviceDistributeJob `json:"Data" xml:"Data"`
}

// CreateQueryDeviceDistributeJobRequest creates a request to invoke QueryDeviceDistributeJob API
func CreateQueryDeviceDistributeJobRequest() (request *QueryDeviceDistributeJobRequest) {
	request = &QueryDeviceDistributeJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QueryDeviceDistributeJob", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryDeviceDistributeJobResponse creates a response to parse from QueryDeviceDistributeJob response
func CreateQueryDeviceDistributeJobResponse() (response *QueryDeviceDistributeJobResponse) {
	response = &QueryDeviceDistributeJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
