package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddEventRecordPlanDevice invokes the linkvisual.AddEventRecordPlanDevice API synchronously
func (client *Client) AddEventRecordPlanDevice(request *AddEventRecordPlanDeviceRequest) (response *AddEventRecordPlanDeviceResponse, err error) {
	response = CreateAddEventRecordPlanDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// AddEventRecordPlanDeviceWithChan invokes the linkvisual.AddEventRecordPlanDevice API asynchronously
func (client *Client) AddEventRecordPlanDeviceWithChan(request *AddEventRecordPlanDeviceRequest) (<-chan *AddEventRecordPlanDeviceResponse, <-chan error) {
	responseChan := make(chan *AddEventRecordPlanDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddEventRecordPlanDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddEventRecordPlanDeviceWithCallback invokes the linkvisual.AddEventRecordPlanDevice API asynchronously
func (client *Client) AddEventRecordPlanDeviceWithCallback(request *AddEventRecordPlanDeviceRequest, callback func(response *AddEventRecordPlanDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddEventRecordPlanDeviceResponse
		var err error
		defer close(result)
		response, err = client.AddEventRecordPlanDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddEventRecordPlanDeviceRequest is the request struct for api AddEventRecordPlanDevice
type AddEventRecordPlanDeviceRequest struct {
	*requests.RpcRequest
	IotId         string           `position:"Query" name:"IotId"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	StreamType    requests.Integer `position:"Query" name:"StreamType"`
	ProductKey    string           `position:"Query" name:"ProductKey"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	DeviceName    string           `position:"Query" name:"DeviceName"`
	PlanId        string           `position:"Query" name:"PlanId"`
}

// AddEventRecordPlanDeviceResponse is the response struct for api AddEventRecordPlanDevice
type AddEventRecordPlanDeviceResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateAddEventRecordPlanDeviceRequest creates a request to invoke AddEventRecordPlanDevice API
func CreateAddEventRecordPlanDeviceRequest() (request *AddEventRecordPlanDeviceRequest) {
	request = &AddEventRecordPlanDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "AddEventRecordPlanDevice", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddEventRecordPlanDeviceResponse creates a response to parse from AddEventRecordPlanDevice response
func CreateAddEventRecordPlanDeviceResponse() (response *AddEventRecordPlanDeviceResponse) {
	response = &AddEventRecordPlanDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
