package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteRtmpDevice invokes the linkvisual.DeleteRtmpDevice API synchronously
func (client *Client) DeleteRtmpDevice(request *DeleteRtmpDeviceRequest) (response *DeleteRtmpDeviceResponse, err error) {
	response = CreateDeleteRtmpDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteRtmpDeviceWithChan invokes the linkvisual.DeleteRtmpDevice API asynchronously
func (client *Client) DeleteRtmpDeviceWithChan(request *DeleteRtmpDeviceRequest) (<-chan *DeleteRtmpDeviceResponse, <-chan error) {
	responseChan := make(chan *DeleteRtmpDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteRtmpDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteRtmpDeviceWithCallback invokes the linkvisual.DeleteRtmpDevice API asynchronously
func (client *Client) DeleteRtmpDeviceWithCallback(request *DeleteRtmpDeviceRequest, callback func(response *DeleteRtmpDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteRtmpDeviceResponse
		var err error
		defer close(result)
		response, err = client.DeleteRtmpDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteRtmpDeviceRequest is the request struct for api DeleteRtmpDevice
type DeleteRtmpDeviceRequest struct {
	*requests.RpcRequest
	IotId         string `position:"Query" name:"IotId"`
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ProductKey    string `position:"Query" name:"ProductKey"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
	DeviceName    string `position:"Query" name:"DeviceName"`
}

// DeleteRtmpDeviceResponse is the response struct for api DeleteRtmpDevice
type DeleteRtmpDeviceResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateDeleteRtmpDeviceRequest creates a request to invoke DeleteRtmpDevice API
func CreateDeleteRtmpDeviceRequest() (request *DeleteRtmpDeviceRequest) {
	request = &DeleteRtmpDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "DeleteRtmpDevice", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteRtmpDeviceResponse creates a response to parse from DeleteRtmpDevice response
func CreateDeleteRtmpDeviceResponse() (response *DeleteRtmpDeviceResponse) {
	response = &DeleteRtmpDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
