package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryDevicePictureByList invokes the linkvisual.QueryDevicePictureByList API synchronously
func (client *Client) QueryDevicePictureByList(request *QueryDevicePictureByListRequest) (response *QueryDevicePictureByListResponse, err error) {
	response = CreateQueryDevicePictureByListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryDevicePictureByListWithChan invokes the linkvisual.QueryDevicePictureByList API asynchronously
func (client *Client) QueryDevicePictureByListWithChan(request *QueryDevicePictureByListRequest) (<-chan *QueryDevicePictureByListResponse, <-chan error) {
	responseChan := make(chan *QueryDevicePictureByListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryDevicePictureByList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryDevicePictureByListWithCallback invokes the linkvisual.QueryDevicePictureByList API asynchronously
func (client *Client) QueryDevicePictureByListWithCallback(request *QueryDevicePictureByListRequest, callback func(response *QueryDevicePictureByListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryDevicePictureByListResponse
		var err error
		defer close(result)
		response, err = client.QueryDevicePictureByList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryDevicePictureByListRequest is the request struct for api QueryDevicePictureByList
type QueryDevicePictureByListRequest struct {
	*requests.RpcRequest
	PictureType   requests.Integer `position:"Query" name:"PictureType"`
	ThumbWidth    requests.Integer `position:"Query" name:"ThumbWidth"`
	IotId         string           `position:"Query" name:"IotId"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	PictureIdList *[]string        `position:"Query" name:"PictureIdList"  type:"Repeated"`
	ExpireTime    requests.Integer `position:"Query" name:"ExpireTime"`
	ProductKey    string           `position:"Query" name:"ProductKey"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	DeviceName    string           `position:"Query" name:"DeviceName"`
}

// QueryDevicePictureByListResponse is the response struct for api QueryDevicePictureByList
type QueryDevicePictureByListResponse struct {
	*responses.BaseResponse
	Code         string                         `json:"Code" xml:"Code"`
	ErrorMessage string                         `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string                         `json:"RequestId" xml:"RequestId"`
	Success      bool                           `json:"Success" xml:"Success"`
	Data         DataInQueryDevicePictureByList `json:"Data" xml:"Data"`
}

// CreateQueryDevicePictureByListRequest creates a request to invoke QueryDevicePictureByList API
func CreateQueryDevicePictureByListRequest() (request *QueryDevicePictureByListRequest) {
	request = &QueryDevicePictureByListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "QueryDevicePictureByList", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryDevicePictureByListResponse creates a response to parse from QueryDevicePictureByList response
func CreateQueryDevicePictureByListResponse() (response *QueryDevicePictureByListResponse) {
	response = &QueryDevicePictureByListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
