package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckLiveMessageUsersInGroup invokes the live.CheckLiveMessageUsersInGroup API synchronously
func (client *Client) CheckLiveMessageUsersInGroup(request *CheckLiveMessageUsersInGroupRequest) (response *CheckLiveMessageUsersInGroupResponse, err error) {
	response = CreateCheckLiveMessageUsersInGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CheckLiveMessageUsersInGroupWithChan invokes the live.CheckLiveMessageUsersInGroup API asynchronously
func (client *Client) CheckLiveMessageUsersInGroupWithChan(request *CheckLiveMessageUsersInGroupRequest) (<-chan *CheckLiveMessageUsersInGroupResponse, <-chan error) {
	responseChan := make(chan *CheckLiveMessageUsersInGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckLiveMessageUsersInGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckLiveMessageUsersInGroupWithCallback invokes the live.CheckLiveMessageUsersInGroup API asynchronously
func (client *Client) CheckLiveMessageUsersInGroupWithCallback(request *CheckLiveMessageUsersInGroupRequest, callback func(response *CheckLiveMessageUsersInGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckLiveMessageUsersInGroupResponse
		var err error
		defer close(result)
		response, err = client.CheckLiveMessageUsersInGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckLiveMessageUsersInGroupRequest is the request struct for api CheckLiveMessageUsersInGroup
type CheckLiveMessageUsersInGroupRequest struct {
	*requests.RpcRequest
	GroupId    string    `position:"Query" name:"GroupId"`
	DataCenter string    `position:"Query" name:"DataCenter"`
	UserIds    *[]string `position:"Query" name:"UserIds"  type:"Repeated"`
	AppId      string    `position:"Query" name:"AppId"`
}

// CheckLiveMessageUsersInGroupResponse is the response struct for api CheckLiveMessageUsersInGroup
type CheckLiveMessageUsersInGroupResponse struct {
	*responses.BaseResponse
	RequestId string      `json:"RequestId" xml:"RequestId"`
	Users     []UsersItem `json:"Users" xml:"Users"`
}

// CreateCheckLiveMessageUsersInGroupRequest creates a request to invoke CheckLiveMessageUsersInGroup API
func CreateCheckLiveMessageUsersInGroupRequest() (request *CheckLiveMessageUsersInGroupRequest) {
	request = &CheckLiveMessageUsersInGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "CheckLiveMessageUsersInGroup", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCheckLiveMessageUsersInGroupResponse creates a response to parse from CheckLiveMessageUsersInGroup response
func CreateCheckLiveMessageUsersInGroupResponse() (response *CheckLiveMessageUsersInGroupResponse) {
	response = &CheckLiveMessageUsersInGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
