package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateRtcAsrTask invokes the live.CreateRtcAsrTask API synchronously
func (client *Client) CreateRtcAsrTask(request *CreateRtcAsrTaskRequest) (response *CreateRtcAsrTaskResponse, err error) {
	response = CreateCreateRtcAsrTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CreateRtcAsrTaskWithChan invokes the live.CreateRtcAsrTask API asynchronously
func (client *Client) CreateRtcAsrTaskWithChan(request *CreateRtcAsrTaskRequest) (<-chan *CreateRtcAsrTaskResponse, <-chan error) {
	responseChan := make(chan *CreateRtcAsrTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateRtcAsrTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateRtcAsrTaskWithCallback invokes the live.CreateRtcAsrTask API asynchronously
func (client *Client) CreateRtcAsrTaskWithCallback(request *CreateRtcAsrTaskRequest, callback func(response *CreateRtcAsrTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateRtcAsrTaskResponse
		var err error
		defer close(result)
		response, err = client.CreateRtcAsrTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateRtcAsrTaskRequest is the request struct for api CreateRtcAsrTask
type CreateRtcAsrTaskRequest struct {
	*requests.RpcRequest
	AuthKey              string           `position:"Query" name:"AuthKey"`
	Language             string           `position:"Query" name:"Language"`
	Mode                 string           `position:"Query" name:"Mode"`
	TranslateEnabled     requests.Boolean `position:"Query" name:"TranslateEnabled"`
	Tag                  string           `position:"Query" name:"Tag"`
	StreamURL            string           `position:"Query" name:"StreamURL"`
	TargetLanguages      string           `position:"Query" name:"TargetLanguages"`
	AutoTerminateEnabled requests.Boolean `position:"Query" name:"AutoTerminateEnabled"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	RtcUserId            string           `position:"Query" name:"RtcUserId"`
	ReportInterval       requests.Integer `position:"Query" name:"ReportInterval"`
	AutoTerminateDelay   requests.Integer `position:"Query" name:"AutoTerminateDelay"`
	SDKAppID             string           `position:"Query" name:"SDKAppID"`
	CallbackURL          string           `position:"Query" name:"CallbackURL"`
	ChannelID            string           `position:"Query" name:"ChannelID"`
}

// CreateRtcAsrTaskResponse is the response struct for api CreateRtcAsrTask
type CreateRtcAsrTaskResponse struct {
	*responses.BaseResponse
	Description string `json:"Description" xml:"Description"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
	RetCode     int64  `json:"RetCode" xml:"RetCode"`
	TaskId      string `json:"TaskId" xml:"TaskId"`
}

// CreateCreateRtcAsrTaskRequest creates a request to invoke CreateRtcAsrTask API
func CreateCreateRtcAsrTaskRequest() (request *CreateRtcAsrTaskRequest) {
	request = &CreateRtcAsrTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "CreateRtcAsrTask", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateRtcAsrTaskResponse creates a response to parse from CreateRtcAsrTask response
func CreateCreateRtcAsrTaskResponse() (response *CreateRtcAsrTaskResponse) {
	response = &CreateRtcAsrTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
